;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;;  Demoralization v1.1.3 - mIRC Picwin demo framework.
;;  (C) Knoeki 2010, All rights and/or wrongs reserved.
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;;  Quick & short usage instructions:
;;
;;  It is advised to put demoralization.mrc and demoralization.ini both in the
;;  same dir together with the scriptfile containing your routines.
;;
;;  You must first initialize the framework, this is simply done by calling
;;  $dmInit. The resolution chooser will pop up. Choosing 'Demo!' will send a
;;  signal (dmInit_End), which you should catch. After this it's all up to you;
;;  Do some initializing first, and then start rendering them frames;
;;
;;  $dmDrawFrame(@dmCanvas, <alias>), where <alias> is (obviously) the alias
;;  containing all those fancy draw commands you want to throw on screen.
;;
;;  Calling $dmShowFPS in your draw routine will show the fps in the top left.
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; Thanks to Tomoya for the awesome name :_)
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

alias dmInit {
    if ($hget(demor) != $null) {
        hfree demor
    }
    hmake -s demor 100
    hload -i demor $qt($scriptdiretc\demoralization.ini)) config
    window -ph @demor
    hadd demor dumpframecount 0
    hadd demor CanvasSize_Width 1
    hadd demor CanvasSize_Height 1
    dialog -dm dmInitDialog dmInitDialog
}

alias dmDrawFrame {
    var %frame_start $ticks
    var %frame_dur $calc(1000 / $hget(demor, target_fps))
    if (($hget(demor, frame_count) <= $calc($hget(demor, target_fps))) && ($ticks < $hget(demor, frame_time))) {
        if (($hget(demor, frame_drop) // $hget(demor, frame_count)) && ($hget(demor, framedropping) == 1)) {
            hinc demor frame_count
        }
        else {
            noop $dmBlankCanvas($1, 0)
            var %x $($+($,$2), 2)
            drawdot $1
;            hinc demor dumpframecount
;            var %fc $hget(demor, dumpframecount)
;            drawsave -b32 @dmCanvas $+(X:\dump\,$str(0, $calc(7 - $len(%fc))),%fc,.bmp)
        }
        hinc demor frame_count
    }
    else {
        hadd demor fps $hget(demor, frame_count)
        hadd demor frame_drop $round($calc(($hget(demor, target_fps) - $hget(demor, frame_count)) * 10), 0)
        hadd demor frame_count 0
        hadd demor frame_time $calc($ticks + 1000)
    }
    if (%x != dmDie) {
        .timerdmDrawFrame -oh 1 $calc((($ticks - %frame_start) - %frame_dur) * 10) noop $!dmDrawFrame( $1 , $2 )
    }
    return
    :error
    echo @test $error
    if ($hget(demor, error_count) > 3) {
        echo @test Encountered 3 errors, cowardly refusing to continue.
        close -@ @demor.*
        hdel demor error_count
        dmDie
        splay stop
    }
    else {
        hinc demor error_count
    }
    timerdmDrawFrame -oh 1 $calc((($ticks - %frame_start) - %frame_dur) * 10) noop $!dmDrawFrame( $1 , $2 )
}

alias -l dmDrawNextFrame {
    dmDrawFrame $1 $2
}

alias dmSleep {
    var %time $calc($ticks + $1)
    while ($ticks < %time) {
        dmWhileFix
    }
    return 1
}

alias dmGenFadeTable {
    var %total $1
    var %count 1
    while (%count < %total) {
        var %result $addtok(%result, %count, 32)
        inc %count
    }
    var %count %total
    while (%count > 1) {
        var %result2 $addtok(%result2, %count, 32)
        dec %count
    }
    return %result %result2
}

alias dmWhileFix {
    dll $qt($scriptdirdll\whilefix.dll) WhileFix .
}

alias dmFullscreen.dll {
    dll $qt($scriptdirdll\fullscreen.dll) $1-
}

alias dmInCanvas {
    if ($prop == x) {
        if (($1 > -64) && ($1 < $hget(demor, CanvasSize_Width))) {
            return $true
        }
        else {
            return $false
        }
    }
    elseif ($prop == y) {
        if (($1 > -64) && ($1 < $hget(demor, CanvasSize_Height))) {
            return $true
        }
        else {
            return $false
        }
    }
}

alias dmShowFps {
    drawtext -nr @dmCanvas 0 fixedsys 12 2 2 fps: $hget(demor, fps)
    drawtext -nr @dmCanvas 16777215 fixedsys 12 0 0 fps: $hget(demor, fps)
}

alias dmBlankCanvas {
    drawrect -nrf $1 $2 1 0 0 $window($1).w $window($1).h
}

alias dmDie {
    echo @test recieved die!
    echo @test $timer(dmdrawframe)
    timerdmdrawframe off
}

alias dmPrecalcAnim {
    hinc demor PrecalcAnimCount
    var %y $calc($hget(demor, CanvasSize_Height) - 18)
    noop $dmBlankCanvas(@dmCanvas, 3302400)
    drawtext -nr @dmCanvas 0 Fixedsys 12 7 $calc(%y + 3) $+(Precalculationizing,$str(., $round($calc($hget(demor, PrecalcAnimCount) / 8))))
    drawtext -nr @dmCanvas 16777215 Fixedsys 12 4 %y $+(Precalculationizing,$str(., $round($calc($hget(demor, PrecalcAnimCount) / 8))))
}


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; Dialog handling
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

dialog dmInitDialog {
    title "demor!"
    size -1 -1 77 51
    option dbu
    text "Resolution:", 1, 3 5 29 8
    combo 2, 34 3 41 11, drop
    check "Fullscreen", 3, 3 15 66 10
    check "Allow frame dropping", 4, 3 26 67 10
    box "", 5, 0 -2 77 40
    button "n__n", 6, 0 39 38 12, default
    button "u__u", 7, 39 39 38 12, cancel
}



on *:DIALOG:dmInitDialog:*:*: {
    var %dname dmInitDialog
    if ($devent == init) {
        didtok %dname 2 44 $hget(demor, resolutions)
        did -c %dname 2 $hget(demor, default_res)
        did $+(-,$iif($hget(demor, framedropping) == 1, c, u)) %dname 4
        /*
        if (($window(-1).w != $gettok($did(%dname, $did(%dname, 2).sel), 1, 42)) || ($window(-1).h != $gettok($did(%dname, 2, $did(%dname, 2).sel), 2, 42))) {
            did -b %dname 3
        }
        else {
            did -e %dname 3
        }
        */
        hadd demor dmInitDialog_PosCount $+(-,$calc(60 * 2))
        ;dialog -bs dmInitDialog -1 $hget(demor, dmInitDialog_PosCount) 98 53
        noop $dmDrawFrame(@demor, $+(dmInitDialog_Anim(open),$iif($hget(demor, init_static) == 1, .static)))
    }
    elseif ($devent == sclick) {
        if ($did == 6) {
            hadd demor dmCanvas_Fullscreen $did(%dname, 3).state
            hadd demor dmInitDialog_PosCount $calc($dialog(dmInitDialog).x / $dbuh)
            hadd demor CanvasSize_Width $gettok($did(%dname, 2, $did(%dname, 2).sel), 1, 42)
            hadd demor CanvasSize_Height $gettok($did(%dname, 2, $did(%dname, 2).sel), 2, 42)
            hadd demor CanvasSize_CenterX $calc($hget(demor, CanvasSize_Width) / 2)
            hadd demor CanvasSize_CenterY $calc($hget(demor, CanvasSize_Height) / 2)
            echo @test CanvasSize: $hget(demor, CanvasSize_Width) * $hget(demor, CanvasSize_Height)
            noop $dmDrawFrame(@demor, $+(dmInitDialog_Anim(close),$iif($hget(demor, init_static) == 1, .static)))
            echo @test meep meep! 2
        }
    }
}


alias dmInitDialog_Anim {
    if ($1 == open) {
        if ($prop == static) {
            ;dialog -bs dmInitDialog -1 -1 98 53
            hadd demor TitleAnim_count $len($hget(demor, dialog_title))
            .timer 1 1 noop $dmDrawFrame(@demor, dmInitDialog_TitleAnim)
            return dmDie
        }
        else {
            if ($hget(demor, dmInitDialog_PosCount) < $calc(($window(-1).h / 2) - 131)) {
                hinc demor dmInitDialog_PosCount 4
                dialog -bs dmInitDialog -1 $calc($hget(demor, dmInitDialog_PosCount) + ($cos($hget(demor, dmInitDialog_PosCount)).deg * 100)) 77 51
            }
            else {
                hdel demor dmInitDialog_PosCount
                hadd demor TitleAnim_count $len($hget(demor, dialog_title))
                .timer 1 1 noop $dmDrawFrame(@demor, dmInitDialog_TitleAnim)
                return dmDie
            }
        }
    }
    elseif ($1 == close) {
        if ($prop == static) {
            .timer 1 1 noop $dmInitDialog_End
            return dmDie
        }
        else {
            if ($hget(demor, dmInitDialog_PosCount) < $window(-1).h) {
                hinc demor dmInitDialog_PosCount 4
                .dialog -bs dmInitDialog -1 $calc($hget(demor, dmInitDialog_PosCount) + ($cos($hget(demor, dmInitDialog_PosCount)).deg * 100)) 77 51
            }
            else {
                .timer 1 1 noop $dmInitDialog_End
                hdel demor dmInitDialog_PosCount
                return dmDie
            }
        }
    }
}
alias dmInitDialog_TitleAnim {
    if ((16 // $hget(demor, frame_count)) && ($dialog(dmInitDialog) != $null)) {
        if ($hget(demor, TitleAnim_count) > 1) {
            dialog -t dmInitDialog $right($($hget(demor, dialog_title), 2), $hget(demor, TitleAnim_Count))
            hdec demor TitleAnim_Count
        }
        else {
            hadd demor TitleAnim_count $len($hget(demor, dialog_title))
        }
    }
}

alias dmInitDialog_End {
    window -dak0pfo @dmCanvas 1 1 $hget(demor, CanvasSize_width) $hget(demor, CanvasSize_height)
    if ($hget(demor, dmCanvas_Fullscreen) == 1) {
        dmFullscreen.dll Fullscreen $window(@dmCanvas).hwnd > $hget(demor, CanvasSize_width) > $hget(demor, CanvasSize_height) > 16 > 60
    }
    .dialog -x dmInitDialog
    .signal dmInit_end
    return dmDie
}