//[VERT]
attribute vec3 position;
attribute vec2 texCoord0;
uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;
varying vec2 vTexCoord0;
uniform float dz;

void main()
{
	//vec3 pos = position * vec3(1.0 - texCoord0.t, 1.0, 1.0 - texCoord0.t);
	gl_Position = projectionMatrix * modelViewMatrix * vec4(position, 1.0);
	gl_Position.z += dz;
	vTexCoord0 = texCoord0;
}

//[FRAG]

uniform vec4 color;
uniform sampler2D tex0;
uniform float useTexture;
varying vec2 vTexCoord0;

void main()
{
	if (useTexture > 0.0) {
		gl_FragColor = texture2D(tex0, vec2(1.0) - vTexCoord0);
	}
	else {
		gl_FragColor = color;
	}
}
