//[VERT]
attribute vec3 position;
attribute vec3 normal;
uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;
varying vec3 vNormal;
varying vec3 vPosition;

void main()
{
	gl_Position = projectionMatrix * modelViewMatrix * vec4(position, 1.0);
	vPosition = position;
	//vNormal = (modelViewMatrix * vec4(normal, 1.0)).xyz;
	vNormal = normal;
}

//[FRAG]

varying vec3 vNormal;
varying vec3 vPosition;
uniform vec4 fadeInColor;

void main()
{
	vec3 lightPos = vec3(5.0, 5.0, 5.0);
	
	vec3 N = normalize(vNormal);
	vec3 L = normalize(lightPos);
	
	//vec3 grass = vec3(0.3, 0.7, 0.2);
	vec3 grass = vec3(0.9, 0.8, 0.2);	
	//vec3 ground = vec3(0.2, 0.5, 0.1);
	vec3 ground = vec3(0.9, 0.4, 0.7);
	//vec3 ground = vec3(0.26, 0.14, 0.07);
	
	float NdotL = dot(N,L);
	float dir = clamp(dot(N, vec3(0.0,1.0,0.0)*2.0), -1.0, 1.0);
	//float colorMix = 0.5 + 0.5*dir;
	float colorMix = dir;
	vec3 color = mix(ground, grass, colorMix);
		
	gl_FragColor.rgb *= vec3(NdotL);
	//gl_FragColor.rgb = vec3(0.2) + (NdotL + 0.2) * color;	
	//gl_FragColor.rgb *= (vPosition.y * 0.5 + 0.7);
	
	//gl_FragColor.rgb = vec3(vPosition.y * 0.5 + 0.7) *  vec3(NdotL*0.5 + 0.5);;
	//gl_FragColor.rgb = color * vec3(vPosition.y * 0.6 + 0.4);// *  vec3(NdotL);
	//gl_FragColor.rgb = vec3(0.5) + 0.5*normalize(vNormal);
	gl_FragColor.rgb = vec3(NdotL*0.5 + 0.5);
	gl_FragColor.rgb += vec3(0.0, 0.3, 0.45);
	gl_FragColor.rgb *= vec3(vPosition.y * 0.6 + 0.4);
	gl_FragColor.rgb = color * vec3(NdotL*0.5 + 0.5);
	
	gl_FragColor.rgb = mix(gl_FragColor.rgb, fadeInColor.rgb, fadeInColor.a);
	
}
