//[VERT]
attribute vec3 position;
attribute vec3 normal;
attribute vec2 texCoord0;

uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;
uniform mat4 modelWorldMatrix;
uniform vec3 camPos;
uniform vec3 lightPos;
uniform vec4 ambientColor;
uniform vec4 diffuseColor;
uniform vec4 specularColor;

varying vec3 reflectDir;
varying vec2 texCoord0Var;
varying vec4 color;

void main()
{
	gl_Position = projectionMatrix * modelViewMatrix * vec4(position, 1.0);	
	vec3 worldPos = vec3(modelWorldMatrix * vec4(position, 1.0));
	vec3 N = normalize(vec3(modelWorldMatrix * vec4(normal, 1.0)));
	vec3 E = normalize(camPos - worldPos);
	vec3 L = normalize(lightPos - worldPos);
	reflectDir = reflect(-E, N);				

	texCoord0Var = texCoord0;
	
	float NdotL = max(0.0, dot(N, L));	
	vec3 R = reflect(-L, N);
	float RdotE = max(0.0, dot(R, E));
	float spec = pow(RdotE, 64.0);
	
	color = ambientColor + diffuseColor*NdotL + specularColor*spec;
	
}

//[FRAG]
uniform samplerCube tex0;
varying highp vec3 reflectDir;
varying highp vec2 texCoord0Var;
varying vec4 color;

void main()
{
	gl_FragColor = color * textureCube(tex0, reflectDir);
}
