//[VERT]
attribute vec3 position;
attribute vec3 normal;

uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;
uniform mat4 modelWorldMatrix;
uniform mat3 normalMatrix;
uniform vec3 camPos;

const float Eta = 0.66;
const float FresnelPower = 2.0;
const float F = ((1.0 - Eta) * (1.0 - Eta)) / ((1.0 + Eta) * (1.0 + Eta));

varying vec3 vReflect;
varying vec3 vRefract;
varying vec3 vInternal;
varying float vRatio;
varying float vDiffuse;
varying float vSpecular;

void main() {
	gl_Position = projectionMatrix * modelViewMatrix * vec4(position, 1.0);
	
	vec3 wPos = (modelWorldMatrix * vec4(position, 1.0)).xyz;
	vec3 i = normalize(wPos - camPos);	
	vec3 N = -normalize(normal);
	
	vRatio = F + (1.0 - F) * pow(1.0 - dot(-i, N), FresnelPower);
	vReflect = reflect(i, N);
	vRefract = refract(i, N, Eta);	
	
	//lighting
	vec3 lightPos = vec3(10.0, 10.0, 10.0);
	vec3 L = -normalize(lightPos - wPos);
	float NdotL = dot(N, L);
	//vDiffuse = max(0.0, NdotL);
	vDiffuse = NdotL;
	
	vec3 E = normalize(camPos - wPos);
	vec3 R = reflect(-L, N);
	float RdotE = max(0.0, dot(R, E));
	vSpecular = pow(RdotE, 64.0);
}

//[FRAG]

uniform samplerCube envMap;
uniform samplerCube internalReflectionMap;
uniform vec4 ambientColor;
uniform vec4 diffuseColor;
uniform vec4 diffuseColor2;
uniform vec4 specularColor;

varying vec3 vReflect;
varying vec3 vRefract;
varying float vRatio;
varying float vDiffuse;
varying float vSpecular;

void main() {	
	vec4 reflectColor = textureCube(envMap, vReflect);
	vec4 refractColor = textureCube(envMap, vRefract);
	
	
	//gl_FragColor = ambientColor + diffuseColor * vDiffuse + specularColor * vSpecular;
	vec4 lightColor = ambientColor + mix(diffuseColor, diffuseColor2, 0.5+0.5*vDiffuse) + specularColor * vSpecular;;
	vec4 reflectionColor = mix(reflectColor, refractColor, vRatio);	
	gl_FragColor = mix(lightColor*lightColor, reflectionColor, 0.9);
	gl_FragColor.a = diffuseColor.a;
}

