//[VERT]
attribute vec3 position;
attribute vec3 normal;
attribute vec3 snormal;
attribute vec2 texCoord0;
attribute float blink;

uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;
uniform mat4 modelWorldMatrix;
uniform mat3 normalMatrix;
uniform vec3 camPos;

const float EtaR = 0.65;
const float EtaG = 0.67;
const float EtaB = 0.69;
const float FresnelPower = 5.0;
const float F = ((1.0 - EtaG) * (1.0 - EtaG)) / ((1.0 + EtaG) * (1.0 + EtaG));

varying vec3 vReflect;
varying vec3 vsReflect;
varying vec3 vRefractR;
varying vec3 vRefractG;
varying vec3 vRefractB;
varying vec3 vInternal;
varying float vRatio;
varying float vDiffuse;
varying float vSpecular;
varying float vBlink;
varying vec3 vN;

void main() {
	gl_Position = projectionMatrix * modelViewMatrix * vec4(position, 1.0);
	
	vec4 ecPosition  = modelViewMatrix * vec4(position, 1.0);
    vec3 ecPosition3 = ecPosition.xyz / ecPosition.w;
	
	vec3 wPos = (modelWorldMatrix * vec4(position, 1.0)).xyz;
	vec3 I = normalize(wPos - camPos);	
	vec3 N = normalize((modelWorldMatrix * vec4(normal, 1.0)).xyz);
	vec3 sN = normalize((modelWorldMatrix * vec4(snormal, 1.0)).xyz);
	vInternal = normal;
	
	if (dot(I,N) > 0.0) {
		N *= -1.0;
	}
	
	vRatio = F + (1.0 - F) * pow(1.0 - dot(-I, N), FresnelPower);
	vReflect = reflect(I, N);
	vsReflect = reflect(I, sN);
	vRefractR = refract(I, N, EtaR);
	vRefractG = refract(I, N, EtaG);
	vRefractB = refract(I, N, EtaB);			
	
	//lighting
	vec3 lightPos = vec3(10.0, 10.0, 10.0);
	vec3 L = normalize(lightPos - wPos);
	float NdotL = dot(N, L);
	vDiffuse = max(0.0, NdotL);
	//vDiffuse = abs(NdotL);
	
	vec3 E = normalize(camPos - wPos);
	vec3 R = normalize(reflect(-L, N));
	float RdotE = max(0.0, dot(R, E));
	//float RdotE = abs(dot(R, E));
	//vSpecular = pow(RdotE, 8.0);
	vSpecular = pow( RdotE, 16.0);
	//vSpecular += vSpecular;
	
	//vInternal = reflect(E,-N);
	vBlink = blink;
	//vBlink = texCoord0.t + texCoord0.s;
	
	vN = normal;	
}

//[FRAG]

uniform samplerCube envMap;
uniform samplerCube internalReflectionMap;
uniform vec4 ambientColor;
uniform vec4 diffuseColor;
uniform vec4 diffuseColor2;
uniform vec4 specularColor;
uniform float internalMix;
uniform float time;

varying vec3 vReflect;
varying vec3 vsReflect;
varying vec3 vRefractR;
varying vec3 vRefractG;
varying vec3 vRefractB;
varying vec3 vInternal;
varying float vRatio;
varying float vDiffuse;
varying float vSpecular;
varying float vBlink;
varying vec3 vN;

void main() {	
	//vec4 reflectColor = textureCube(envMap, vReflect);	
	vec4 reflectColor = textureCube(envMap, vReflect);
	float d = 0.051;
	reflectColor.r += textureCube(envMap, vsReflect + vec3(d,d,d)).r;
	reflectColor.g += textureCube(envMap, vsReflect).r;
	reflectColor.b += textureCube(envMap, vsReflect + vec3(-d,-d,-d)).r;		
	
	vec4 refractColor = textureCube(envMap, vRefractR);
	refractColor.rgb = vec3(textureCube(envMap, vRefractR).r, textureCube(envMap, vRefractG).g, textureCube(envMap, vRefractB).b);
	vec4 internalColor = textureCube(internalReflectionMap, vInternal);
	float blink = max(0.0, (sin(time + vBlink*2.0*3.14159265) + sin(time/2.0 + vBlink*2.0*3.14159265) - 1.0)*2.0);
	
	vec4 lightColor = ambientColor + diffuseColor * max(0.0, vDiffuse) + specularColor * vSpecular;;
	vec4 reflectionColor = mix(refractColor, reflectColor, 1.0-vRatio);
	//gl_FragColor = mix(lightColor, reflectionColor, specularColor.a);
	gl_FragColor = mix(mix(lightColor, diffuseColor2, blink), reflectionColor, specularColor.a);
	
	//gl_FragColor = mix(mix(lightColor, diffuseColor2, blink), reflectionColor, 0.8);
	//gl_FragColor = reflectionColor;
	//gl_FragColor = refractColor;
	//gl_FragColor = mix(lightColor, reflectionColor, specularColor.a);
	//gl_FragColor = reflectionColor;//mix(reflectionColor, specularColor.a);
	
	//gl_FragColor = lightColor + reflectionColor;
	//gl_FragColor.rgb = lightColor.rgb;	
	gl_FragColor.a = diffuseColor.a;
	//gl_FragColor.a = 0.5;
	//gl_FragColor.rgb = diffuseColor2.rgb;
	//gl_FragColor.rgb = vec3(vBlink);
	
	//gl_FragColor.rgb = vec3(0.5) + 0.5*vN;
}

