//[VERT]
attribute vec3 position;
attribute vec3 normal;

uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;
uniform mat4 modelWorldMatrix;
uniform mat3 normalMatrix;
uniform vec3 camPos;

const float Eta = 0.66;
const float FresnelPower = 4.0;
const float F = ((1.0 - Eta) * (1.0 - Eta)) / ((1.0 + Eta) * (1.0 + Eta));

varying vec3 vReflect;
varying vec3 vRefract;
varying float vRatio;


void main() {
	gl_Position = projectionMatrix * modelViewMatrix * vec4(position, 1.0);
	
	vec3 wPos = (modelWorldMatrix * vec4(position, 1.0)).xyz;
	vec3 i = normalize(wPos - camPos);	
	vec3 n = normalize(normal);
	
	vRatio = F + (1.0 - F) * pow(1.0 - dot(-i, n), FresnelPower);
	vReflect = reflect(i, n);
	vRefract = refract(i, n, Eta);	
}

//[FRAG]

uniform samplerCube envMap;
uniform vec4 diffuseColor;

varying vec3 vReflect;
varying vec3 vRefract;
varying float vRatio;

void main() {	
	vec3 reflectColor = textureCube(envMap, vReflect).rgb;
	//reflectColor = vec3(0.5, 0.5, 0.5);
	vec3 refractColor = textureCube(envMap, vRefract).rgb;
	//refractColor = vec3(0.5, 0.5, 0.5);
	gl_FragColor.rgb = mix(reflectColor, refractColor, vRatio);
	gl_FragColor.a = 1.0;
	//gl_FragColor.rgb += vec3(vRatio*0.2);
	gl_FragColor *= diffuseColor;		
}

