import java.util.*;
import java.awt.*;
import java.awt.geom.*;
import javax.swing.event.*;
import javax.swing.*;

public abstract class XformSkeleton extends ParameterGroup implements Xform, ParameterListener {
	ParameterListener listener;
	String[] labels;

	JPanel gui_panel;

	public XformSkeleton() {
		super("XFORM_PARAMS", null, null);
	}

	public void init(ParameterListener listener, 
	String title, String[] labels, double[] init_vals) {
		this.listener = listener;
		this.labels = labels;
		//this.title = title; FIXME

		for(int i=0; i<init_vals.length / 3; i++) {
			double min_val = init_vals[i*3+0];
			double max_val = init_vals[i*3+1];
			double init_val = init_vals[i*3+2];
			addParameter(new SliderParameter(labels[i],
				min_val, max_val, init_val));
		}
		
		if(listener != null) listener.parameterChanged(this);
	}

	public JComponent getGUI() {
		return super.createGUIComponent();
	}

	public abstract String getLabel();

	/* slider listener */
	public void parameterChanged(Object src) {
		double[] a = new double[labels.length];
		for(int i=0; i<labels.length; i++) {
			a[i] = getDouble(labels[i]);
		}
		setXFDoubles(a);
		if(listener != null) listener.parameterChanged(this);
	}

	public void setXFDoubles(double[] v) {}

	public abstract void iterate(double[] coord);

	public boolean isXformNull() { return false; }
}
