public class XformPoly3D extends XformSkeleton {
	double[] a;

	public XformPoly3D(ParameterListener listener) {
		init(listener, getLabel(), new String[] {
			"x'=1*", "x'=x*",  "x'=y*",  "x'=z*",
			"x'=x^2*",  "x'=y^2*",  "x'=z^2*",
			"x'=xy*", "x'=xz*", "x'=yz*",
			
			"y'=1*",  "y'=x*",  "y'=y*",  "y'=z*",
			"y'=x^2*",  "y'=y^2*",  "y'=z^2*",
			"y'=xy*", "y'=xz*", "y'=yz*",

			"z'=1*",  "z'=x*",  "z'=y*",  "z'=z*",
			"y'=x^2*",  "y'=y^2*",  "y'=z^2*",
			"z'=xy*", "z'=xz*", "z'=yz*", 
		}, new double[] {
			-2,2,0, -2,2,.75, -2,2,0, -2,2,0,
			-1,1,0, -1,1,0, -1,1,0, 
			-1,1,0, -1,1,0, -1,1,0, 
			-2,2,0, -2,2,0, -2,2,.75, -2,2,0, 
			-1,1,0, -1,1,0, -1,1,0, 
			-1,1,0, -1,1,0, -1,1,0, 
			-2,2,0, -2,2,0, -2,2,0, -2,2,.75, 
			-1,1,0, -1,1,0, -1,1,0, 
			-1,1,0, -1,1,0, -1,1,0, 
		});
	}

	public String getLabel() { return "3D Polynomial"; }

	public void setXFDoubles(double[] v) {
		a = v;
	}

	public void iterate(double[] c) {
		if(a == null) return; // FIXME
		double x = 1.0*a[0] + c[0]*a[1] + c[1]*a[2] + c[2]*a[3] +
			c[0]*c[0]*a[4] + c[1]*c[1]*a[5] + c[2]*c[2]*a[6] +
			c[0]*c[1]*a[7] + c[0]*c[2]*a[8] + c[1]*c[2]*a[9];
		double y = 1.0*a[10] + c[0]*a[11] + c[1]*a[12] + c[2]*a[13] +
			c[0]*c[0]*a[14] + c[1]*c[1]*a[15] + c[2]*c[2]*a[16] +
			c[0]*c[1]*a[17] + c[0]*c[2]*a[18] + c[1]*c[2]*a[19];
		double z = 1.0*a[20] + c[0]*a[21] + c[1]*a[22] + c[2]*a[23] +
			c[0]*c[0]*a[24] + c[1]*c[1]*a[25] + c[2]*c[2]*a[26] +
			c[0]*c[1]*a[27] + c[0]*c[2]*a[28] + c[1]*c[2]*a[29];
		c[0] = x;
		c[1] = y;
		c[2] = z;
		for(int i=3; i<c.length; i++) c[i] = 0;
	}
}
