public class XformPoly extends XformSkeleton {
	double[] a;

	public XformPoly(ParameterListener listener) {
		init(listener, getLabel(), new String[] {
			"x'=1*", "x'=x*", "x'=y*", "x'=xy*", "x'=x^2*", "x'=y^2*",
			"y'=1*", "y'=x*", "y'=y*", "y'=xy*", "y'=x^2*", "y'=y^2*",
		}, new double[] {
			-2,2,0, -2,2,.5, -2,2,0, -2,2,0, -2,2,0, -2,2,0, 
			-2,2,0, -2,2,0, -2,2,.5, -2,2,0, -2,2,0, -2,2,0, 
		});
	}

	public String getLabel() { return "2D Polynomial"; }

	public void setXFDoubles(double[] v) {
		a = v;
	}

	public void iterate(double[] z) {
		if(a == null) return; // FIXME
		double x = 1.0*a[0] + z[0]*a[1] + z[1]*a[2] +
			z[0]*z[1]*a[3] + z[0]*z[0]*a[4] + z[1]*z[1]*a[5];
		double y = 1.0*a[6] + z[0]*a[7] + z[1]*a[8] +
			z[0]*z[1]*a[9] + z[0]*z[0]*a[10] + z[1]*z[1]*a[11];
		z[0] = x;
		z[1] = y;
		for(int i=2; i<z.length; i++) z[i] = 0;
	}
}
