import java.awt.geom.*;

public class XformAffine3D extends XformSkeleton {
	double[] matrix;
	double[] shift = new double[3];
	double[] c2 = new double[3];
	ParameterListener listener;

	public XformAffine3D(ParameterListener listener) {
		this.listener = listener;
		addParameter(new SliderParameter("tx", -2, 2, 0));
		addParameter(new SliderParameter("ty", -2, 2, 0));
		addParameter(new SliderParameter("tz", -2, 2, 0));
		addParameter(new SliderParameter("rot axis lon", -180, 180, 0));
		addParameter(new SliderParameter("rot axis lat", -90, 90, 0));
		addParameter(new SliderParameter("rot angle", -180, 180, 0));
		addParameter(new SliderParameter("sx", -2, 2, .5));
		addParameter(new SliderParameter("sy", -2, 2, .5));
		addParameter(new SliderParameter("sz", -2, 2, .5));
	}

	public String getLabel() { return "Affine 3D"; }

	public void parameterChanged(Object src) {
		shift[0] = getDouble("tx"); 
		shift[1] = getDouble("ty"); 
		shift[2] = getDouble("tz"); 
		double rot_lon = getDouble("rot axis lon") * Math.PI / 180.0;
		double rot_lat = getDouble("rot axis lat") * Math.PI / 180.0;
		double rot_ang = getDouble("rot angle") * Math.PI / 180.0;
		double sx = getDouble("sx");
		double sy = getDouble("sy"); 
		double sz = getDouble("sz"); 
		
		double axis_x = Math.cos(rot_lat) * Math.sin(rot_lon);
		double axis_y = Math.sin(rot_lat);
		double axis_z = Math.cos(rot_lat) * Math.cos(rot_lon);

		matrix = Matrix3D.getRotMat(axis_x, axis_y, axis_z, rot_ang);
		matrix = Matrix3D.matrixMult(matrix, Matrix3D.getScaleMat(sx, sy, sz));
		if(listener != null) listener.parameterChanged(this);
	}

	public void iterate(double[] coord) {
		if(matrix == null) return;
		Matrix3D.vecMult(c2, matrix, coord);
		coord[0] = c2[0] + shift[0];
		coord[1] = c2[1] + shift[1];
		coord[2] = c2[2] + shift[2];
		for(int i=3; i<coord.length; i++) coord[i] = 0;
	}
}
