import java.util.*;
import java.awt.*;
import java.awt.event.*;
import java.text.*;
import javax.swing.event.*;
import javax.swing.*;

public class SliderParameter 
implements AdjustableParameter, ChangeListener, ActionListener {
	ArrayList<ParameterListener> listeners = new ArrayList<ParameterListener>();
	JComponent gui;
	JSlider slider;
	JTextField slider_edit;
	String slider_id;
	String slider_label;
	String slider_tooltip;
	double slider_value;
	double slider_min;
	double slider_max;
	boolean ignore_events;

	public SliderParameter(
		String slider_id,
		double slider_min, double slider_max, double slider_default
	) {
		this(slider_id, slider_id, null, slider_min, slider_max, slider_default);
	}

	public SliderParameter(
		String slider_id, String slider_label,
		double slider_min, double slider_max, double slider_default
	) {
		this(slider_id, slider_label, null, slider_min, slider_max, slider_default);
	}

	public SliderParameter(
		String slider_id, String slider_label, String slider_tooltip,
		double slider_min, double slider_max, double slider_default
	) {
		this.slider_id = slider_id;
		this.slider_label = slider_label;
		this.slider_tooltip = slider_tooltip;
		this.slider_min = slider_min;
		this.slider_max = slider_max;
		this.slider_value = slider_default;
	}

	public void addParameterListener(ParameterListener l) {
		listeners.add(l);
	}

	public void removeParameterListener(ParameterListener l) {
		listeners.remove(l);
	}

	public JComponent createGUIComponent() {
		if(gui != null) return gui;
		slider = new JSlider(0, 100, 0);
		slider.addChangeListener(this);
		JPanel panel = new JPanel();
		slider_edit = new JTextField(4);
		slider_edit.addActionListener(this);
		panel.add(new JLabel(slider_label));
		panel.add(slider_edit);
		panel.add(slider);
		syncNewValue(slider_value, false);
		this.gui = panel;
		return gui;
	}

	public String getID() { return slider_id; }

	public String getLabel() { return slider_label; }
	
	public String getTooltip() { return slider_tooltip; }

	public void setParams(Object p) {
		syncNewValue(((Double)p).doubleValue(), true);
	}

	public Object getParams() {
		return new Double(slider_value);
	}

	public Object[] interpolate(Object[] seq_obj, double pos) {
		double[] seq;
		if(seq_obj[0].equals(seq_obj[seq_obj.length-1])) {
			int loop_around = 4;
			seq = new double[seq_obj.length + loop_around*2];
			for(int i=0; i<seq.length; i++) {
				int j = (i-loop_around) % (seq_obj.length-1);
				while(j<0) j += (seq_obj.length-1);
				seq[i] = ((Double)seq_obj[j]).doubleValue();
			}
			pos += loop_around;
		} else {
			seq = new double[seq_obj.length];
			for(int i=0; i<seq.length; i++) {
				seq[i] = ((Double)seq_obj[i]).doubleValue();
			}
		}
//String zz = "";
//for(int i=0; i<seq.length; i++) zz += " "+seq[i];
//System.out.println("id="+slider_id+", seq = ["+zz+" ], pos="+pos);
		Cubic[] polys = NatCubic.calcNaturalCubic(seq);
		int pos_int = (int)Math.floor(pos);
		if(pos_int == seq.length-1) pos_int--;
		Object interp = new Double(
			polys[pos_int].eval(pos - (double)pos_int));
		return new Object[] { interp, interp };
	}

	public void mutate(AdjustableParameter source, 
	double exp, double mult, boolean allow_gaps) {
		try {
			double v = ((Double)source.getParams()).doubleValue();
			double diff = slider_max - slider_min;
			double rnd = Math.pow(Math.random(), exp) * mult;
			double sign_odds = (v - slider_min) / diff;
			if(Math.random() < sign_odds) rnd = -rnd;
			v += diff * rnd;
			if(v < slider_min) v = slider_min;
			if(v > slider_max) v = slider_max;
			setParams(new Double(v));
		} catch(Exception e) {
			e.printStackTrace();
		}
	}

	public String freeze() { return ""+slider_value; }

	public void thaw(String s) throws Exception {
		syncNewValue(Double.parseDouble(s), true);
	}

	private void syncNewValue(double val, boolean notify_listeners) {
		slider_value = val;
//System.out.println("sync "+slider_id+"="+val+" ("+slider_min+".."+slider_max+")");
		ignore_events = true; // prevent feedback...
		if(slider != null) {
			slider.setValue((int)(100.0 * 
				(slider_value - slider_min) / 
				(slider_max - slider_min)));
		}
		if(slider_edit != null) {
			DecimalFormat df = new DecimalFormat(".##");
			slider_edit.setText(df.format(slider_value));
		}
		ignore_events = false;
		if(notify_listeners) {
			for(ParameterListener l : listeners) {
				l.parameterChanged(this);
			}
		}
	}

	public void stateChanged(ChangeEvent evt) {
//System.out.println("ign="+ignore_events);
		if(ignore_events) return;
		syncNewValue(((double)slider.getValue() / 100.0)
			* (slider_max - slider_min) + slider_min, true);
	}

	public void actionPerformed(ActionEvent evt) {
//System.out.println("ign="+ignore_events);
		if(ignore_events) return;
		try {
			syncNewValue(Double.parseDouble(slider_edit.getText()), true);
		} catch(NumberFormatException e) {
			syncNewValue(slider_value, false);
		}
	}
}
