import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

public class DispOptionsPanel extends ParameterGroup {
	private JComponent gui;

	public DispOptionsPanel(MainPanel listener) {
		super("DISP_OPTIONS", "Display Options", null);

		addParameter(new SliderParameter("Offset", 0, 30, 0));
		addParameter(new SliderParameter("Scale",  0,  3, 1));
		addParameter(new SliderParameter("Gamma", .2,  4, 1));

		addParameterListener(listener);
	}

	public JComponent createGUIComponent() {
		if(gui != null) return gui;

		JPanel inner_panel = new JPanel();
		inner_panel.setLayout(new BoxLayout(inner_panel, BoxLayout.Y_AXIS));

		inner_panel.add(super.createGUIComponent());

		JScrollPane sp = new JScrollPane(inner_panel);
		JPanel panel = new JPanel();
		panel.setLayout(new BorderLayout());
		panel.add(sp, BorderLayout.CENTER);

		this.gui = panel;
		return gui;
	}

	public void genImage(
		int[] buffer32, long[] buffer64, int[] rgb, int width, int height
	) {
		double color_offset = getDouble("Offset");
		double color_scale  = getDouble("Scale");
		double color_gamma  = getDouble("Gamma");

//		if(buffer32 != null)
//			System.out.println("image from 32-bit source");
//		else
//			System.out.println("image from 64-bit source");

		long maxval = 0;
		long minval = Long.MAX_VALUE;
		for(int i=0; i<width*height*3; i++) {
			long val;
			if(buffer32 != null) val = (long)buffer32[i];
			else                 val = buffer64[i];
			if(val > maxval) maxval = val;
			if(val < minval) minval = val;
		}
		double maxlog = Math.log(maxval+1);
		double minlog = Math.log(minval+1);
		double off = minlog + color_offset;
		double sc = color_scale / (maxlog-minlog);
		int[] c  = new int[3];
		int j;
		for(int i=0; i<width*height; i++) {
			for(j=0; j<3; j++) {
				long val;
				if(buffer32 != null) val = (long)buffer32[i*3+j];
				else                 val = buffer64[i*3+j];
				if(val == 0) {
					c[j] = 0;
				} else {
					double logval = Math.log(val+1);
					logval -= off;
					logval *= sc;
					logval = Math.pow(logval, color_gamma);
					logval *= 255.0;
					if(logval < 0.0) c[j] = 0;
					else if(logval > 255.0) c[j] = 255;
					else c[j] = (int)logval;
				}
			}
			rgb[i] = 0xff000000 + 
				(c[0] << 16) +
				(c[1] << 8) +
				c[2];
		}
	}
}
