import java.awt.geom.*;

public class XformRipple extends XformSkeleton {
	ParameterListener listener;
	XformSkeleton pre_ripple_affine;
	XformSkeleton post_ripple_affine;
	XformSkeleton non_ripple_affine;

	public XformRipple(ParameterListener listener) {
		this.listener = listener;
		addParameter(pre_ripple_affine = new XformAffine3D(this));
		addParameter(post_ripple_affine = new XformAffine3D(this));
		addParameter(non_ripple_affine = new XformAffine3D(this));

		pre_ripple_affine.setLabel("Pre-ripple");
		pre_ripple_affine.setBorder(true);
		post_ripple_affine.setLabel("Post-ripple");
		post_ripple_affine.setBorder(true);
		non_ripple_affine.setLabel("Non-ripple");
		non_ripple_affine.setBorder(true);
	}

	public String getLabel() { return "Ripple 3D"; }

	public void parameterChanged(Object src) {
		if(listener != null) listener.parameterChanged(this);
	}

	public void iterate(double[] coord) {
		double[] wave = new double[coord.length];
		for(int i=0; i<coord.length; i++) wave[i] = coord[i];
		pre_ripple_affine.iterate(wave);
		for(int i=0; i<3; i++) wave[i] = Math.sin(wave[i]);
		post_ripple_affine.iterate(wave);
		non_ripple_affine.iterate(coord);
		for(int i=0; i<3; i++) coord[i] += wave[i];
	}
}
