public class XformQuaternion extends XformSkeleton {
	double[] coef_c = new double[4];
	double[] coef_b = new double[4];
	double[] coef_a = new double[4];

	public XformQuaternion(ParameterListener listener) {
		init(listener, "a*z^2 + b*z + c", new String[] {
			"c_1", "c_i", "c_j", "c_k",
			"b_1", "b_i", "b_j", "b_k",
			"a_1", "a_i", "a_j", "a_k",
		}, new double[] {
			-1,1,0, -1,1,0, -1,1,0, -1,1,0, 
			-1,1,1, -1,1,0, -1,1,0, -1,1,0, 
			-1,1,0, -1,1,0, -1,1,0, -1,1,0, 
		});
	}

	public String getLabel() { return "Quaternion Polynomial 4D"; }

	public void setXFDoubles(double[] v) {
		coef_c[0] = v[0]; coef_c[1] = v[1]; coef_c[2] = v[2]; coef_c[3] = v[3];
		coef_b[0] = v[4]; coef_b[1] = v[5]; coef_b[2] = v[6]; coef_b[3] = v[7];
		coef_a[0] = v[8]; coef_a[1] = v[9]; coef_a[2] = v[10]; coef_a[3] = v[11];
	}

	public void iterate(double[] c) {
		if(coef_a == null) return; // FIXME

		// shuffle 1,i,j,k to i,j,k,1
		double tmp = c[3];
		for(int i=3; i>0; i--) c[i] = c[i-1];
		c[0] = tmp;

		double[] c_squared = Matrix3D.quatMult(c, c);
		double[] ac2 = Matrix3D.quatMult(coef_a, c_squared);
		double[] bc  = Matrix3D.quatMult(coef_b, c);
		for(int i=0; i<4; i++)
			c[i] = ac2[i] + bc[i] + coef_c[i];

		tmp = c[0];
		for(int i=0; i<3; i++) c[i] = c[i+1];
		c[3] = tmp;
		for(int i=4; i<c.length; i++) c[i] = 0;
	}
}
