import java.awt.geom.*;

public class XformHelix extends XformSkeleton {
	double[] c2 = new double[3];
	double[] matrix_f;
	double[] matrix_r;
	double rot_off, rot_scale, tx, ty, zoom;

	public XformHelix(ParameterListener listener) {
		init(listener, getLabel(), new String[] {
			"axis lon", "axis lat", "rot offset", "rot scale",
			"tx", "ty", "scale"
		}, new double[] {
			-180,180,0, -90,90,90, -180,180,0, -720,720,0,
			-1,1,0, -1,1,0, -1,1,.5
		});
	}

	public String getLabel() { return "Helix 3D"; }

	public void setXFDoubles(double[] v) {
		double axis_lon = v[0] * Math.PI / 180.0;
		double axis_lat = v[1] * Math.PI / 180.0;
		rot_off = v[2] * Math.PI / 180.0;
		rot_scale = v[3] * Math.PI / 180.0;
		tx = v[4];
		ty = v[5];
		zoom = v[6];

//		double axis_x = Math.cos(axis_lat) * Math.sin(axis_lon);
//		double axis_y = Math.sin(axis_lat);
//		double axis_z = Math.cos(axis_lat) * Math.cos(axis_lon);

		double ax2_lon = axis_lon + Math.PI / 2.0;
		double ax2_x = Math.sin(ax2_lon);
		double ax2_y = 0;
		double ax2_z = Math.cos(ax2_lon);

		matrix_f = Matrix3D.getRotMat(ax2_x, ax2_y, ax2_z, -axis_lat);
		matrix_r = Matrix3D.getRotMat(ax2_x, ax2_y, ax2_z, axis_lat);
	}

	public void iterate(double[] coord) {
		if(matrix_f == null) return;
		Matrix3D.vecMult(c2, matrix_f, coord);
		double ang = c2[2] * rot_scale - rot_off;
		double sin = Math.sin(ang);
		double cos = Math.cos(ang);
		double x =  c2[0]*cos + c2[1]*sin;
		double y = -c2[0]*sin + c2[1]*cos;
		c2[0] = x;
		c2[1] = y;
		Matrix3D.vecMult(coord, matrix_r, c2);
		coord[0] += tx;
		coord[1] += ty;
		coord[0] *= zoom;
		coord[1] *= zoom;
		coord[2] *= zoom;
		for(int i=3; i<coord.length; i++) coord[i] = 0;
	}
}
