import java.awt.geom.*;

public class XformAffine extends XformSkeleton {
	double a00, a01, a10, a11, t0, t1;
	ParameterListener listener;

	public XformAffine(ParameterListener listener) {
		this.listener = listener;
		addParameter(new SliderParameter("tx", -2, 2, 0));
		addParameter(new SliderParameter("ty", -2, 2, 0));
		addParameter(new SliderParameter("rot", -180, 180, 0));
		addParameter(new SliderParameter("sx", -2, 2, 1));
		addParameter(new SliderParameter("sy", -2, 2, 1));
		addParameter(new SliderParameter("shx", -2, 2, 0));
		addParameter(new SliderParameter("shy", -2, 2, 0));
	}

	public String getLabel() { return "Affine 2D"; }

	public void parameterChanged(Object src) {
		double tx = getDouble("tx"); 
		double ty = getDouble("ty");
		double rot = getDouble("rot") * Math.PI / 180.0;
		double sx = getDouble("sx");
		double sy = getDouble("sy"); 
		double shx = getDouble("shx");
		double shy = getDouble("shy");

		AffineTransform affine = new AffineTransform();
		affine.concatenate(AffineTransform.getScaleInstance(sx, sy));
		affine.concatenate(AffineTransform.getShearInstance(shx, shy));
		affine.concatenate(AffineTransform.getTranslateInstance(tx, ty));
		affine.concatenate(AffineTransform.getRotateInstance(rot));
		
		double[] matrix = new double[6];
		affine.getMatrix(matrix);
		
		a00 = matrix[0];
		a01 = matrix[1];
		a10 = matrix[2];
		a11 = matrix[3];
		t0 = matrix[4];
		t1 = matrix[5];

		if(listener != null) listener.parameterChanged(this);
	}

	public void iterate(double[] coord) {
		double x = coord[0]*a00 + coord[1]*a01;
		double y = coord[0]*a10 + coord[1]*a11;
		coord[0] = x + t0;
		coord[1] = y + t1;
		for(int i=2; i<coord.length; i++) coord[i] = 0;
	}
}
