import java.util.*;
import java.text.*;
import java.io.*;
import java.awt.*;
import java.awt.image.*;
import java.awt.event.*;
import javax.swing.*;

public class StandaloneImageGenerator implements FractalListener {
	long num_iter;
	int width;
	int height;
	String out_fn;
	boolean all_done;

	public StandaloneImageGenerator(int width, int height, long num_iter_in,
	String out_fn, String params) throws Exception { 
		this.width = width;
		this.height = height;
		this.num_iter = num_iter_in;
		this.out_fn = out_fn;

		if(num_iter <= 0) num_iter = Long.MAX_VALUE;

		System.out.println("\nframe "+out_fn);

		GenOptionsPanel gen_options = new GenOptionsPanel(null);
		DispOptionsPanel disp_options = new DispOptionsPanel(null);
		XformChooser[] xforms = new XformChooser[IFS.NUM_XFORMS];
		for(int xf=0; xf<IFS.NUM_XFORMS; xf++) {
			xforms[xf] = new XformChooser(null);
		}
		AllParamsSerializer.thaw(params, xforms, gen_options, disp_options);
		all_done = false;
		ComputeThread computer = new ComputeThread(
			1, num_iter<1000000?num_iter:1000000, false, true);
		computer.setSize(width, height);
		computer.setListener(this);
	
		computer.setParams(xforms, gen_options);
		computer.setDispParams(disp_options);
			 
		synchronized(this) { 
			while(!all_done) { wait(); }
		}
	
		computer.quitSoon();

		System.out.println("exit");
	}

	public StandaloneImageGenerator(
	int width, int height, int num_iter, int steps_per_keyframe,
	String out_base, String[] keyframes)
	throws Exception { 
		this.width = width;
		this.height = height;
		this.num_iter = num_iter;

		GenOptionsPanel gen_options = new GenOptionsPanel(null);
		DispOptionsPanel disp_options = new DispOptionsPanel(null);
		Object[][] xform_params = new Object[IFS.NUM_XFORMS][keyframes.length];
		Object[] gen_params = new Object[keyframes.length];
		Object[] disp_params = new Object[keyframes.length];

		for(int kf=0; kf<keyframes.length; kf++) {
			XformChooser[] xforms = new XformChooser[IFS.NUM_XFORMS];
			for(int xf=0; xf<IFS.NUM_XFORMS; xf++) {
				xforms[xf] = new XformChooser(null);
			}
			AllParamsSerializer.thaw(keyframes[kf], xforms, gen_options, disp_options);
			for(int xf=0; xf<IFS.NUM_XFORMS; xf++) {
				xform_params[xf][kf] = xforms[xf].getParams();
				if(xform_params[xf][kf] == null) throw new NullPointerException();
//System.out.println("xf keys["+xf+"]["+kf+"]=\n"+xforms[xf].freeze());
			}
			gen_params[kf] = gen_options.getParams();
			disp_params[kf] = disp_options.getParams();
		}

		for(
			int kf=0;
			kf<keyframes.length-1;
//			kf<keyframes.length;
			kf++
		) for(
			double alpha = 0; 
			(kf==keyframes.length-2) ? (alpha<=1.0) : (alpha<0.999999); 
//			alpha < 1.0;
			alpha += 1.0/(double)steps_per_keyframe
		) {
			all_done = false;
			DecimalFormat df = new DecimalFormat("0000.000");
			out_fn = out_base + "-" + df.format((double)kf+alpha) + ".ppm";
			System.out.println("\nframe "+out_fn);
			ComputeThread computer = new ComputeThread(
				1, num_iter<1000000?num_iter:1000000, false, true);
			computer.setSize(width, height);
			computer.setListener(this);
	
//System.out.println("phase 1");
			XformChooser xx = new XformChooser(null);
			Xform[] xforms = new Xform[IFS.NUM_XFORMS];
			Object[] params;
			for(int xf=0; xf<IFS.NUM_XFORMS; xf++) {
				Object[] key_params = xform_params[xf];
				params = xx.interpolate(key_params, (double)kf+alpha);
				if(params[0] == params[1]) {
//System.out.println("xforms["+xf+"]=xfc");
					xforms[xf] = new XformChooser(null);
					((XformChooser)xforms[xf]).setParams(params[0]);
//System.out.println(((XformChooser)xforms[xf]).freeze());
				} else {
//System.out.println("xforms["+xf+"]=int");
					XformChooser xf_a = new XformChooser(null);
					XformChooser xf_b = new XformChooser(null);
					xf_a.setParams(params[0]);
					xf_b.setParams(params[1]);
					xforms[xf] = new XformInterpolator(xf_a, xf_b, alpha);
				}
			}
			params = disp_options.interpolate(disp_params, (double)kf+alpha);
			disp_options.setParams(params[0]);
			params = gen_options.interpolate(gen_params, (double)kf+alpha);
//System.out.println("p="+params[0]);
			gen_options.setParams(params[0]);

for(int i=0; i<xforms.length; i++)
System.out.println("xf"+i+"="+xforms[i]);
//System.out.println("phase 2");

			computer.setParams(xforms, gen_options);
			computer.setDispParams(disp_options);
//System.out.println("phase 5");
			 
			synchronized(this) { 
				while(!all_done) { wait(); }
			}
	
			computer.quitSoon();
		}

		System.out.println("exit");
	}

	public void fractalImageGenerated(BufferedImage img, boolean show_text, 
	long num_iter, boolean maxxed, boolean oob) {
		System.out.println("iter="+num_iter);
		if(num_iter == 0) return;

		int[] rgb1 = img.getRGB(0, 0, width, height, null, 0, width);
		byte[] rgb2 = new byte[width*height*3];
		for(int i=0; i<width*height; i++) {
			rgb2[i*3+0] = (byte)((rgb1[i] >> 16) & 0xff);
			rgb2[i*3+1] = (byte)((rgb1[i] >>  8) & 0xff);
			rgb2[i*3+2] = (byte)((rgb1[i]      ) & 0xff);
		}
		try {
			FileOutputStream w = new FileOutputStream(out_fn);
			String header = "P6\n"+width+" "+height+"\n255\n";
			w.write(header.getBytes());
			w.write(rgb2);
			w.close();
		} catch(Exception e) {
			e.printStackTrace();
		}

		if(num_iter >= this.num_iter) {
			all_done = true;
			synchronized(this) { 
				notify();
			}
		}
	}
}
