import javax.swing.*;
import java.awt.event.*;
import java.io.*;

public class SaveLoadPanel extends JPanel implements ActionListener {
	MainPanel main_panel;
	String params;
	JTextField params_area;
	JButton save_button;
	int save_idx;

	public SaveLoadPanel(MainPanel main_panel, boolean is_applet) {
		this.main_panel = main_panel;

//		setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
		params_area = new JTextField(20);
		params_area.addActionListener(this);
		add(params_area);
		if(!is_applet) {
			save_button = new JButton("Save as "+getNextFilename());
			save_button.addActionListener(this);
			add(save_button);
		}
	}

	public void setParams(String params) {
		this.params = params;
		params_area.setText(params);
	}

	public void actionPerformed(ActionEvent evt) {
		if(evt.getSource() == (Object)params_area) {
			try {
				main_panel.setParamsFromString(
					params_area.getText());
			} catch(Exception e) {
			}
		} else if(evt.getSource() == (Object)save_button) {
			try {
				FileWriter fh = new FileWriter(getNextFilename());
				fh.write(params);
				fh.close();
				save_idx++;
				save_button.setText("Save as "+getNextFilename());
			} catch(Exception e) {
				e.printStackTrace();
			}
		}
	}

	public String getNextFilename() {
		return "keyframe-"+save_idx+".ifs";
	}
}
