import java.util.*;
import java.awt.*;
import java.awt.event.*;
import java.text.*;
import javax.swing.event.*;
import javax.swing.*;

public class ObjectParameter implements AdjustableParameter {
	ArrayList<ParameterListener> listeners = new ArrayList<ParameterListener>();
	String id;
	Object val;

	public ObjectParameter(String id, Object val) {
		this.id = id;
//System.out.println("new ObjectParameter("+id+","+val+")");
		this.val = val;
	}

	public void addParameterListener(ParameterListener l) {
		listeners.add(l);
	}

	public void removeParameterListener(ParameterListener l) {
		listeners.remove(l);
	}

	public JComponent createGUIComponent() {
		return null;
	}

	public String getID() { return id; }

	public String getLabel() { return id; }
	
	public String getTooltip() { return null; }

	public void setParams(Object val) {
		this.val = val;
//(new Exception()).printStackTrace();
//System.out.println("ObjectParameter.setParams: "+id+","+val);
		for(ParameterListener l : listeners) {
			l.parameterChanged(this);
		}
	}

	public Object getParams() {
		return val;
	}

	public Object[] interpolate(Object[] seq_obj, double pos_f) {
		int pos = (int)Math.floor(pos_f);
		Object left_obj = (Object)( 
			pos < 0 ? seq_obj[0] :
			pos >= seq_obj.length ? seq_obj[seq_obj.length-1] :
			seq_obj[pos]);
		pos++;
		Object right_obj = (Object)(
			pos < 0 ? seq_obj[0] :
			pos >= seq_obj.length ? seq_obj[seq_obj.length-1] :
			seq_obj[pos]);
		if(
			(right_obj == null && left_obj == null) ||
			(right_obj != null && right_obj.equals(left_obj))
		) right_obj = left_obj;
System.out.println("interpolate on object "+left_obj+","+right_obj+","+(right_obj==left_obj));
		return new Object[] { left_obj, right_obj };
	}

	public void mutate(AdjustableParameter source, 
	double exp, double mult, boolean allow_gaps) {
		try {
			setParams(source.getParams());
		} catch(Exception e) {
			e.printStackTrace();
		}
	}

	// FIXME - null?
	public String freeze() { return val==null ? "null" : val.toString(); }

	public void thaw(String s) throws Exception {
//System.out.println("ObjectParameter.thaw("+id+","+val+")");
		setParams(s);
	}
}
