import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

public class MutatorPanel extends JPanel implements MouseListener, ParameterListener {
	private static final int NUM_ROWS = 4;
	private static final int NUM_COLS = 3;
	private static final int NUM_NEW = NUM_ROWS * NUM_COLS;
	private MainPanel listener;
	private AdjustableParameter slider;
	private double variance;
	private ComputeThread[] computers;
	private FractalMonitor[] monitors;
	private XformChooser[][] new_xf;
	private XformChooser[] orig_xf;
	private GenOptionsPanel gen_options;
	private DispOptionsPanel disp_options;
	private boolean mutator_visible;

	public MutatorPanel(MainPanel listener) {
		setLayout(new BorderLayout());

		slider = new SliderParameter("Variance", 0, .2, .03);
		slider.addParameterListener(this);
		add(slider.createGUIComponent(), BorderLayout.NORTH);

		JPanel image_panel = new JPanel();
		//ComputeGroup compute_group = new ComputeGroup();
		computers = new ComputeThread[NUM_NEW];
	 	monitors = new FractalMonitor[NUM_NEW];
		new_xf = new XformChooser[NUM_NEW][];
		image_panel.setLayout(new GridLayout(NUM_ROWS, NUM_COLS));
		for(int i=0; i<NUM_NEW; i++) {
			computers[i] = new ComputeThread(1, 1000, true, false);
			//computers[i].setGroup(compute_group);
			monitors[i] = new FractalMonitor(computers[i], false);
			monitors[i].addMouseListener(this);
			image_panel.add(monitors[i]);
		}
		add(image_panel, BorderLayout.CENTER);

		parameterChanged(this);
		
		this.listener = listener;
	}

	public void parameterChanged(Object src) {
		variance = ((Double)slider.getParams()).doubleValue();
		setParams(orig_xf, gen_options);
	}

	public void mouseClicked(MouseEvent evt) {
		for(int i=0; i<monitors.length; i++) {
			if(evt.getSource() == (Object)monitors[i]) {
				listener.mutatorChosen(new_xf[i]);
			}
		}
	}

	public void mousePressed(MouseEvent evt) { }
	public void mouseReleased(MouseEvent evt) { }
	public void mouseEntered(MouseEvent evt) { }
	public void mouseExited(MouseEvent evt) { }

	public void setMutatorVisible(boolean state) {
		if(mutator_visible == state) return;
		mutator_visible = state;
		if(state) {
			setParams(orig_xf, gen_options);
			setDispParams(disp_options);
		} else {
			for(int i=0; i<NUM_NEW; i++) {
				computers[i].setParams(null, null);
			}
		}
	}

	public void setParams(XformChooser[] orig_xf, GenOptionsPanel gen_options) {
		this.orig_xf = orig_xf;
		this.gen_options = gen_options;
		if(!mutator_visible) return;

		for(int i=0; i<NUM_NEW; i++) {
			if(new_xf[i] == null || new_xf[i].length != orig_xf.length) {
				new_xf[i] = new XformChooser[orig_xf.length];
				for(int j=0; j<orig_xf.length; j++) {
					new_xf[i][j] = new XformChooser(null);
				}
			}
			for(int j=0; j<orig_xf.length; j++) {
				new_xf[i][j].mutate(orig_xf[j], 2, variance, false);
			}
			monitors[i].makeBlank();
			computers[i].setParams(new_xf[i], gen_options);
		}
	}

	public void setDispParams(DispOptionsPanel disp_options) {
		this.disp_options = disp_options;
		if(!mutator_visible) return;

		for(int i=0; i<NUM_NEW; i++) {
			monitors[i].makeBlank();
			computers[i].setDispParams(disp_options);
		}
	}
}
