public class Matrix3D {
	public static double[] matrixMult(double[] a, double[] b) {
		double[] out = new double[9];
		for(int row=0; row<3; row++) for(int col=0; col<3; col++) {
			out[row*3+col] = 
				a[row*3+0] * b[0*3+col] +
				a[row*3+1] * b[1*3+col] +
				a[row*3+2] * b[2*3+col];
		}
		return out;
	}

	public static double[] matrixMult(double[] a, double scalar) {
		double[] out = new double[9];
		for(int i=0; i<9; i++)
			out[i] = a[i] * scalar;
		return out;
	}

	public static void vecMult(double[] out, double[] m, double[] v) {
		for(int i=0; i<3; i++)
			out[i] = 
				m[i*3+0] * v[0] +
				m[i*3+1] * v[1] +
				m[i*3+2] * v[2];
	}

	public static double[] quatToMat(double w, double x, double y, double z) {
		double[] m = new double[9];
		m[0] = w*w + x*x - y*y - z*z;
		m[1] = 2*x*y - 2*w*z;
		m[2] = 2*x*z + 2*w*y;
		m[3] = 2*x*y + 2*w*z;
		m[4] = w*w - x*x + y*y - z*z;
		m[5] = 2*y*z - 2*w*x;
		m[6] = 2*x*z - 2*w*y;
		m[7] = 2*y*z + 2*w*x;
		m[8] = w*w - x*x - y*y + z*z;
		return m;
	}

	public static double[] quatMult(double[] a, double[] b) {
		// FIXME - check
		double[] out = new double[4];
		out[0] = (a[3]*b[3] - a[0]*b[0] - a[1]*b[1] - a[2]*b[2]);
		out[1] = (a[3]*b[0] + a[0]*b[3] + a[1]*b[2] - a[2]*b[1]);
		out[2] = (a[3]*b[1] - a[0]*b[2] + a[1]*b[3] + a[2]*b[0]);
		out[3] = (a[3]*b[2] + a[0]*b[1] - a[1]*b[0] + a[2]*b[3]);
		return out;
	}

	public static double[] getRotMat(double ax, double ay, double az, double ang) {
		double len = Math.sqrt(ax*ax + ay*ay + az*az);
		if(len == 0) {
			ax = 1; ay = az = 0;
		} else {
			ax /= len;  ay /= len;  az /= len;
		}
		double w = Math.cos(ang/2.0);
		double x = ax * Math.sin(ang/2.0);
		double y = ay * Math.sin(ang/2.0);
		double z = az * Math.sin(ang/2.0);
		return quatToMat(w, x, y, z);
	}

	public static double[] getScaleMat(double sx, double sy, double sz) {
		double[] m = new double[9];
		m[0] = sx;
		m[4] = sy;
		m[8] = sz;
		return m;
	}

	public static void dumpMatrix(double[] m) {
		for(int row=0; row<3; row++)
			System.out.println("["+m[row*3+0]+", "+m[row*3+1]+", "+m[row*3+2]+"]");
	}
}
