import java.util.*;
import java.awt.*;
import java.awt.image.*;
import java.awt.event.*;
import javax.swing.*;

public class MainPanel extends JPanel implements ParameterListener, ActionListener {
	private static final String STR_XFORMS = "XF";
	private static final String STR_GEN = "Generation";
	private static final String STR_DISP = "Display";
	private static final String STR_MUTATE = "Mutator";
	private static final String STR_SAVELOAD = "Save/Load";
	private static final Color BG_NORMAL = Color.lightGray;
	private static final Color BG_SEL = Color.red;

	XformChooser xforms[];
	GenOptionsPanel gen_options;
	DispOptionsPanel disp_options;
	MutatorPanel mutator;
	SaveLoadPanel save_load;

	JButton[] card_buttons;
	CardLayout card_layout;
	JPanel card_panel;

	ComputeThread computer;
	boolean listen_to_param_change;

	public MainPanel(String init_params, boolean is_applet) { 
		setupPanel(is_applet);

		try {
System.out.println("loading default fractal");
			AllParamsSerializer.thaw(
				DefaultFractal.getDefaultFractalParams(),
				xforms, gen_options, disp_options);
		} catch(Exception e) {
			e.printStackTrace();
		}

		if(init_params != null) {
			try { setParamsFromString(init_params); }
			catch(Exception e) {}
		}
		listen_to_param_change = true;
		dispParameterChanged();
		parameterChanged(this);
	}

	private void setupPanel(boolean is_applet) {
		JPanel button_panel1 = new JPanel();
		JPanel button_panel2 = new JPanel();
		JPanel button_panel_main = new JPanel();
		button_panel1.setLayout(new BoxLayout(button_panel1, BoxLayout.X_AXIS));
		button_panel2.setLayout(new BoxLayout(button_panel2, BoxLayout.X_AXIS));
		button_panel_main.setLayout(new BoxLayout(button_panel_main, BoxLayout.Y_AXIS));
		button_panel_main.add(button_panel1);
		button_panel_main.add(button_panel2);

		card_layout = new CardLayout();
		card_panel = new JPanel(card_layout);

		card_buttons = new JButton[8];
		int but_iter = 0;

		xforms = new XformChooser[IFS.NUM_XFORMS];
		for(int i=0; i<IFS.NUM_XFORMS; i++) {
			xforms[i] = new XformChooser(this);
			String str = STR_XFORMS+" "+i;
			card_buttons[but_iter] = new JButton(str);
			card_buttons[but_iter].addActionListener(this);
			button_panel1.add(card_buttons[but_iter]);
			card_panel.add(xforms[i].getGUI(), str);
			but_iter++;
		}

		card_buttons[but_iter] = new JButton(STR_GEN);
		card_buttons[but_iter].addActionListener(this);
		button_panel2.add(card_buttons[but_iter]);
		gen_options = new GenOptionsPanel(this);
		card_panel.add(gen_options.createGUIComponent(), STR_GEN);
		but_iter++;

		card_buttons[but_iter] = new JButton(STR_DISP);
		card_buttons[but_iter].addActionListener(this);
		button_panel2.add(card_buttons[but_iter]);
		disp_options = new DispOptionsPanel(this);
		card_panel.add(disp_options.createGUIComponent(), STR_DISP);
		but_iter++;

		card_buttons[but_iter] = new JButton(STR_MUTATE);
		card_buttons[but_iter].addActionListener(this);
		button_panel2.add(card_buttons[but_iter]);
		mutator = new MutatorPanel(this);
		card_panel.add(mutator, STR_MUTATE);
		but_iter++;

		card_buttons[but_iter] = new JButton(STR_SAVELOAD);
		card_buttons[but_iter].addActionListener(this);
		button_panel2.add(card_buttons[but_iter]);
		save_load = new SaveLoadPanel(this, is_applet);
		card_panel.add(save_load, STR_SAVELOAD);
		but_iter++;

		if(but_iter != card_buttons.length) {
			throw new IndexOutOfBoundsException("wrong number of buttons");
		}

		for(int i=0; i<card_buttons.length; i++) {
			card_buttons[i].setBackground(
				i==0 ? BG_SEL : BG_NORMAL);
		}

		JPanel control_panel = new JPanel();
		control_panel.setLayout(new BorderLayout());
		control_panel.add(card_panel, BorderLayout.CENTER);
		control_panel.add(button_panel_main, BorderLayout.NORTH);

		computer = new ComputeThread(5, 10000, false, false);

		FractalMonitor monitor = new FractalMonitor(computer, true);
		JPanel monitor_panel = new JPanel();
		monitor_panel.setLayout(new GridLayout(1, 1));
		monitor_panel.add(monitor);

		setLayout(new BorderLayout());
		JSplitPane split_pane = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT,
			control_panel, monitor_panel);
		add(split_pane, BorderLayout.CENTER);
	}

	public void actionPerformed(ActionEvent evt) {
		JButton button = (JButton)evt.getSource();
		for(int i=0; i<card_buttons.length; i++) {
			card_buttons[i].setBackground(
				card_buttons[i] == button ? BG_SEL : BG_NORMAL);
		}
		card_layout.show(card_panel, button.getText());
		mutator.setMutatorVisible(button.getText().equals(STR_MUTATE));
	}

	public String getParamString() {
		return AllParamsSerializer.freeze(xforms, gen_options, disp_options);
	}

	public void setParamsFromString(String param_string) throws Exception {
		AllParamsSerializer.thaw(param_string, xforms, gen_options, disp_options);
	}

	public void parameterChanged(Object src) {
		if(!listen_to_param_change) return;
		if(src == (Object)disp_options) {
			dispParameterChanged();
		} else {
			if(computer != null) computer.setParams(xforms, gen_options);
			if(mutator != null) mutator.setParams(xforms, gen_options);
			if(save_load != null) save_load.setParams(getParamString());
		}
	}

	public void dispParameterChanged() {
		if(computer != null) computer.setDispParams(disp_options);
		if(computer != null) mutator.setDispParams(disp_options);
	}

	public void mutatorChosen(XformChooser[] new_xf) {
		listen_to_param_change = false;
		for(int i=0; i<xforms.length; i++) {
			xforms[i].copy(new_xf[i]);
		}
		listen_to_param_change = true;
		parameterChanged(this);
	}

	public void dispose() {
		if(computer != null) computer.quitSoon();
	}
}
