import java.util.*;

public abstract class IndentReader {
	public static HashMap<String, String> readIndentString(String in) {
		if(in == null) throw new NullPointerException();
		HashMap<String, String> out = new HashMap<String, String>();
		StringTokenizer st = new StringTokenizer(in, "\n");
		String key = null;
		String val = null;
		while(st.hasMoreTokens()) {
			String line = st.nextToken();
			if(line.startsWith("\t")) {
				if(key == null) throw new IllegalStateException(
					"cannot parse input ["+line+"]");
				if(val != null) val += "\n";
				else val = "";
				val += line.substring(1, line.length());
			} else {
				if(key != null) out.put(key, val);
				key = line;
				val = null;
			}
		}
		if(key != null) out.put(key, val);
		return out;
	}

	public static String addTabToEveryLine(String in) {
		String out = "";
		StringTokenizer st = new StringTokenizer(in, "\n");
		while(st.hasMoreTokens()) {
			String line = st.nextToken();
			out += "\t"+line+"\n";
		}
		return out;
	}
}
