import java.awt.*;
import java.awt.image.*;
import javax.swing.*;

public class FractalMonitor extends JComponent implements FractalListener {
	ComputeThread computer;
	boolean grid_enabled;
	BufferedImage img;
	int[][][][][] grid;
	boolean blank = true;
	String text_to_show = null;

	public FractalMonitor(ComputeThread computer, boolean grid_enabled) {
		this.computer = computer;
		this.grid_enabled = grid_enabled;
		makeBlank();
		computer.setListener(this);
	}

	public void setBounds(int x, int y, int w, int h) {
		super.setBounds(x, y, w, h);
		computer.setSize(w, h);
	}

	public void gridGenerated(int[][][][][] grid) {
		this.grid = grid;
		repaint();
	}

	public void fractalImageGenerated(BufferedImage img, boolean show_text, 
	long num_iter, boolean maxxed, boolean oob) {
		this.img = img;
//System.out.println("image done iter="+num_iter);
		if(show_text) {
			String iter_txt = num_iter > 1000000 ?
				(num_iter/1000000)+" million" : ""+num_iter;
			text_to_show = iter_txt+" iterations";
			if(maxxed) text_to_show += ", some points maxed out";
			if(oob) text_to_show += ", out of bounds";
		} else {
			// show 'oob' in preview pane
			text_to_show = oob ? "oob" : null;
		}
		if(img == null) grid = null;
		blank = false;
		repaint();
	}

	public void makeBlank() {
		blank = true;
		grid = null;
		text_to_show = null;
		repaint();
	}

	public void paintComponent(Graphics g) {
		if(blank) {
			g.setColor(Color.black);
			g.fillRect(0, 0, getWidth(), getHeight());
		} else {
			if(img != null) g.drawImage(img, 0, 0, null);
			if(text_to_show != null) {
				g.setColor(Color.white);
				g.drawString(text_to_show, 5, getHeight()-5);
			}
			/*
			if(grid != null) {
				//int xfid = 0;
				for(int xfid=0; xfid<grid.length; xfid++)
				for(int iter=grid[0].length-1; iter>=0; iter--) {
					int c = 64+(int)((grid[xfid].length-iter) *
						((255.0-64.0) / (double)(grid[xfid].length)));
					// FIXME - color
					switch(xfid) {
						case 0: g.setColor(new Color(c, 0, 0)); break;
						case 1: g.setColor(new Color(0, c, 0)); break;
						case 2: g.setColor(new Color(0, 0, c)); break;
						case 3: g.setColor(new Color(c, c, c)); break;
					}
					for(int step_x=0; step_x<grid[0][0].length; step_x++)
					for(int step_y=0; step_y<grid[0][0][0].length-1; step_y++)
						g.drawLine(
							grid[xfid][iter][step_x][step_y][0],
							grid[xfid][iter][step_x][step_y][1],
							grid[xfid][iter][step_x][step_y+1][0],
							grid[xfid][iter][step_x][step_y+1][1]
						);
					for(int step_x=0; step_x<grid[0][0].length-1; step_x++)
					for(int step_y=0; step_y<grid[0][0][0].length; step_y++)
						g.drawLine(
							grid[xfid][iter][step_x][step_y][0],
							grid[xfid][iter][step_x][step_y][1],
							grid[xfid][iter][step_x+1][step_y][0],
							grid[xfid][iter][step_x+1][step_y][1]
						);
				}
			}
			*/
		}
	}
}
