import java.util.*;
import java.awt.image.*;

public class ComputeThread extends Thread {
	static int num_objects = 0;
	Random rand = new Random();
	public boolean end_thread, restart_thread;
	FractalListener listener;
	int priority;
	long iter_preview;
	boolean redisplay;
	boolean shitty_preview;
	boolean enable_stereo;
	boolean show_iter;
	boolean use64;
	static ComputeGroup group = new ComputeGroup();
	BufferedImage preview_img;
	int width, height;
	Xform[] xforms;
	GenOptionsPanel gen_options;
	DispOptionsPanel disp_options;
	double scale_single, scale_stereo;
	int[] buffer32;
	long[] buffer64;
	boolean maxxed_out, out_of_bounds;

	public ComputeThread(
		int priority, long iter_preview, boolean mutator_panel, boolean file_output
	) {
		super("ifs computer #"+(num_objects++));
		
		this.priority = priority;
		this.iter_preview = iter_preview;
		this.shitty_preview = false;//!mutator_panel && !file_output;
		this.enable_stereo = !mutator_panel;
		this.show_iter = !mutator_panel && !file_output;
		this.use64 = file_output;

		setSize(50, 50);

//System.out.println("start to begin thread "+this);
		start();
	}

	public void setListener(FractalListener listener) {
		this.listener = listener;
	}

	public void quitSoon() {
//System.out.println("qs enter");
		end_thread = true;
		synchronized(this) {
//System.out.println("qs sync");
			notifyAll();
		}
	}

	public void setSize(int w, int h) {
		if(w==0 || h==0) return;
//System.out.println("ss enter");
synchronized(this) {
//System.out.println("ss sync");
		this.width = w;
		this.height = h;
		scale_single = Math.min(width, height) / 2.0;
		scale_stereo = Math.min(width/2, height) / 2.0;
		if(use64) buffer64 = new long[width*height*3];
		else      buffer32 = new int [width*height*3];
		preview_img = new BufferedImage(
			width, height, BufferedImage.TYPE_INT_RGB);

		restart_thread = true;
		notifyAll();
}
		sendGridInfo();

//		System.out.println("size="+w+","+h);
	}

	public void setParams(Xform[] xforms, GenOptionsPanel gen_options) {
//System.out.println("sp enter");
synchronized(this) {
//System.out.println("sp sync");
		if(xforms == null) xforms = new XformChooser[0];
		int num = 0;
		for(int i=0; i<xforms.length; i++) {
			if(!xforms[i].isXformNull()) num++;
		}
		Xform[] xf = new Xform[num];
		int j=0;
		for(int i=0; i<xforms.length; i++) {
			if(!xforms[i].isXformNull()) xf[j++] = xforms[i];
		}
		this.xforms = xf;
		this.gen_options = gen_options;

		restart_thread = true;
		notifyAll();
}
		sendGridInfo();
	}

	public void setDispParams(DispOptionsPanel disp_options) {
		this.disp_options = disp_options;
		redisplay = true;
	}

	public boolean readyToGo() {
		return 
			xforms != null && 
			xforms.length > 0 &&
			disp_options != null;
	}

	public void run() {
//System.out.println("begin thread "+this);
		while(!end_thread) {
//if(show_iter) System.out.println("begin of outer loop "+this);
			restart_thread = false;
//if(show_iter) System.out.println("wait for xforms "+this);
			if(!readyToGo()) {
				group.leaveGroup(this);
				while(!readyToGo()) {
//System.out.println("null xforms or disp "+(xforms==null?"null":""+xforms.length)+","+disp_options);
					try { sleep(100);
					} catch(InterruptedException e2) { }
				}
			}
//if(show_iter) System.out.println("join group "+this);
			group.joinGroup(this);
			try {
//System.out.println("start compute loop "+this);
				run2();
			// thread safety :)
			} catch(Exception e) { 
				e.printStackTrace();
				try { sleep(100);
				} catch(InterruptedException e2) { }
			}
//if(show_iter) System.out.println("end of outer loop "+this);
		}
//if(show_iter) System.out.println("leave group "+this);
		group.leaveGroup(this);
//System.out.println("end thread "+this);
	}
	
	private void run2() {
		long iter;

		if(use64) for(int i=0; i<width*height*3; i++) buffer64[i] = 0;
		else      for(int i=0; i<width*height*3; i++) buffer32[i] = 0;
		double[] coord = new double[4];
		long update_at = iter_preview;
		out_of_bounds = maxxed_out = false;

		int[] color = new int[3];
		for(iter=0; ; iter++) {
			if(end_thread) break;
			if(restart_thread && iter > iter_preview) break;
			if(iter == update_at) {
				sendImage(iter);
				if(update_at<250000) update_at *= 4;
				else if(update_at < 19000000) update_at += 1000000;
				else update_at += 10000000;
			} else if(redisplay) {
				sendImage(iter);
				redisplay = false;
			}
//System.out.println("ml wait");
			if(0 == (iter%1000)) group.waitForOthers(this, iter / priority);
//System.out.println("ml enter");
synchronized(this) {
//System.out.println("ml sync");
			if(end_thread) break;
			if(restart_thread && iter > iter_preview) break;
			int xfid = rand.nextInt(xforms.length);

			boolean[] ret_flags = new boolean[2];
			gen_options.iterate(
				iter, ret_flags, xforms[xfid], xfid,
				coord, color, buffer32, buffer64, width, height,
				enable_stereo, scale_single, scale_stereo);
			maxxed_out |= ret_flags[0];
			out_of_bounds |= ret_flags[1];
}
		}
	}

	private void sendGridInfo() {
	/*
		if(listener == null) return;
		if(xforms == null) return;
		if(!listener.grid_enabled) return;

		int num_iter = 1;
		int num_steps = 11;
		int[][][][][] grid = new int[xforms.length][num_iter][num_steps][num_steps][2];
		double[] coord = new double[2];
		for(int xfid=0; xfid<xforms.length; xfid++) {
		for(int step_x=0; step_x<num_steps; step_x++) {
		for(int step_y=0; step_y<num_steps; step_y++) {
			coord[0] = -1.0 + (double)step_x / (double)(num_steps-1) * 2.0;
			coord[1] = -1.0 + (double)step_y / (double)(num_steps-1) * 2.0;
			for(int iter=0; iter<num_iter; iter++) {
				xforms[xfid].iterate(coord);
				int x =  (int)(coord[0] * scale) + width/2;
				int y = -(int)(coord[1] * scale) + height/2;
				grid[xfid][iter][step_x][step_y][0] = x;
				grid[xfid][iter][step_x][step_y][1] = y;
			}
		}
		}
		}

		listener.gridGenerated(grid);
	*/
	}

	private void sendImage(long iter) {
		int[] rgb = new int[width*height];
		if(iter == iter_preview && shitty_preview) {
			if(use64) {
				for(int i=0; i<width*height; i++) {
					rgb[i] = 0xff000000 + 
						(buffer64[i*3+0]!=0 ? 0x00ff0000 : 0) +
						(buffer64[i*3+1]!=0 ? 0x0000ff00 : 0) +
						(buffer64[i*3+2]!=0 ? 0x000000ff : 0);
				}
			} else {
				for(int i=0; i<width*height; i++) {
					rgb[i] = 0xff000000 + 
						(buffer32[i*3+0]!=0 ? 0x00ff0000 : 0) +
						(buffer32[i*3+1]!=0 ? 0x0000ff00 : 0) +
						(buffer32[i*3+2]!=0 ? 0x000000ff : 0);
				}
			}
		} else {
			disp_options.genImage(buffer32, buffer64, rgb, width, height);
		}
		if(restart_thread && iter > iter_preview) return;
		preview_img.setRGB(0, 0, width, height, rgb, 0, width);
		if(restart_thread && iter > iter_preview) return;
		if(listener != null) listener.fractalImageGenerated(
			preview_img, show_iter,  iter,
			maxxed_out, out_of_bounds);
	}
}
