import java.util.*;

public class ComputeGroup {
	int num_threads = 0;
	int num_locked = 0;
	HashMap<ComputeThread, Long> thread_progress = new HashMap<ComputeThread, Long>();

	synchronized public void joinGroup(ComputeThread new_thread) {
		if(thread_progress.get(new_thread) != null)
			num_threads--;
		thread_progress.put(new_thread, new Long(0));
		num_threads++;
		notifyAll();
	}

	synchronized public void leaveGroup(ComputeThread old_thread) {
		thread_progress.remove(old_thread);
		num_threads--;
		notifyAll();
	}

	synchronized public void waitForOthers(ComputeThread whoami, long iter) {
		thread_progress.put(whoami, new Long(iter));
		num_locked++;
		notifyAll();
//System.out.println(iter+","+getMin()+","+num_locked+","+num_threads);
		while(iter > getMin() || num_locked < num_threads) { 
//if(whoami.show_iter) {
//System.out.println("enter: et="+whoami.end_thread+", rt="+whoami.restart_thread);
//}
			try { wait(); }
			catch(InterruptedException e) { }
//if(whoami.show_iter) {
//System.out.println("iter="+iter+", min="+getMin());
//System.out.println("nl="+num_locked+", nt="+num_threads);
//System.out.println("et="+whoami.end_thread+", rt="+whoami.restart_thread);
//}
			if(whoami.end_thread || whoami.restart_thread) break;
		}
//System.out.println("t="+(Thread)whoami);
		num_locked--;
	}

	private long getMin() {
		Long[] vals = (Long[])thread_progress.values().toArray(new Long[0]);
		long min = Long.MAX_VALUE;
		for(int i=0; i<vals.length; i++) {
			long val = vals[i].longValue();
			if(min > val) min = val;
		}
		return min;
	}
}
