/*

  Name      :  Hardware VGM player
  Hardware  :  YM2612 & SN76489
  Software  :  VGM 1.5 Spec
  Notes     :  Music Playback using sound chips from sega genesis

*/
#define int8    unsigned char
#define int16   unsigned short
#define int32   unsigned long

#define BUFFER_LENGTH                     30
#define IMGBUFFER_LENGTH                  30

// VGM commands
#define VGM_HEADER                      "Vgm "
#define VGM_CMD_GG_STEREO               0x4F
#define VGM_CMD_PSG                     0x50
#define VGM_CMD_YM2413                  0x51
#define VGM_CMD_YM2612_0                0x52
#define VGM_CMD_YM2612_1                0x53
#define VGM_CMD_2151                    0x54
#define VGM_CMD_WAIT                    0x61
#define VGM_CMD_WAIT_735                0x62
#define VGM_CMD_WAIT_882                0x63
#define VGM_PAUSE_BYTE                  0x64
#define VGM_CMD_EOF                     0x66
#define VGM_CMD_DATA_BLOCK              0x67
#define VGM_CMD_YM2612_PCM_SEEK         0xE0

// VGM file header
struct TVGMHeader{
  char	VGMIdent[4];	        // "Vgm "
  long	EoFOffset;		// relative offset (from this point, 0x04) of the end of file
  long	Version;		// 0x00000101 for 1.01
  long	PSGClock;		// typically 3579545, 0 for no PSG
  long	FMClock;		// typically , 0 for no FM
  long	YM2413Clock;		// typically 3579545, 0 for no FM
  long	YM2151Clock;		// typically 3579545, 0 for no FM
  long	YM2612Clock;		// typically 3579545, 0 for no FM
  long	GD3Offset;		// relative offset (from this point, 0x14) of the Gd3 tag, 0 if not present
  long	TotalLength;	        // in samples
  long	LoopOffset;		// relative again (to 0x1c), 0 if no loop
  long	LoopLength;		// in samples, 0 if no loop	
  long	RecordingRate;	        
  long	SNFB;	        
  long	SNW;
  long	DataOffset;	       
} 
VGMHeader;

/*
// GD3 file header
struct TGD3Header{
  char	Gd3Ident[4];	        // "Gd3 "
  char	Title[32];	        //
  char	Author[32];	        //
  char	GameName[32];	        //
  char	GameSystem[32];	        //
  char	Date[16];	        //
  long	Version;		// 0x00000101 for 1.01
  long	TotalLength;	        // in samples
} 
GD3Header;
*/

// the software SPI protocol GHI uses
//#define NDT 0xff
//#define HDT 0xfe

