/*

 Name      :  Vectorballs
 Notes     :  2D circles spinning in 3D space
 
 A vector ball is a 2D Sprite represented in 3D space.
 Based on code by Peter Knight, Tinker.it
 
 references:
 http://code.google.com/p/tinkerit/
 
 */

// proce55ing logo in 3D data points
#define NUM_BALLS 28
PROGMEM prog_char ballPosnX[NUM_BALLS] = {-3,-2,-1,0,1,-3,-2,1,2,-3,-2,1,2,-3,-2,1,2,-3,-2,-1,0,1,-3,-2,-3,-2,1,3};
PROGMEM prog_char ballPosnY[NUM_BALLS] = {3,3,3,3,3,2,2,2,2,1,1,1,1,0,0,0,0,-1,-1,-1,-1,-1,-2,-2,-3,-3,-3,-3};

void vectorball(int x, int y, int w, int h){  
  float ballX[NUM_BALLS];
  float ballY[NUM_BALLS];
  float ballZ[NUM_BALLS];
  static float angx = 0;
  static float angy = 0;
  static float angz = 0;

  byte timeDisplacement=250;// number of frames to run
  byte page=0;              // double buffer counter

  do
  {    
    page = timeDisplacement & 1; // fast modulo operation using bitwise AND (same as: timeDisplacement % 2)

    for (byte i = 0; i <100; i++)
    {
      vgm();
    }   

    switchWritePage(page);
    vgm();
    rect(107,68,200,131,0);  // erase monitor with black background
    vgm();

    float cosangx = fpu_cos(angx);
    float sinangx = fpu_sin(angx);
    float cosangy = fpu_cos(angy);
    float sinangy = fpu_sin(angy);
    float cosangz = fpu_cos(angz);
    float sinangz = fpu_sin(angz);
    vgm();

    for (int n=0; n<NUM_BALLS; n++) {
      int x = (signed char)pgm_read_byte(&ballPosnX[n]);
      int y = (signed char)pgm_read_byte(&ballPosnY[n]);
      int z = 0;

      // Rotate about x axis
      float x2 = x;
      float y2 = y * cosangx - z * sinangx;
      float z2 = y * sinangx + z * cosangx;

      // Rotate about y axis
      float x3 = x2 * cosangy + z2 * sinangy;
      float y3 = y2;
      float z3 = -x2 * sinangy + z2 * cosangy;

      // Rotate about z axis
      float x4 = x3 * cosangz - y3 * sinangz;
      float y4 = x3 * sinangz + y3 * cosangz;
      float z4 = z3;

      ballX[n] = x4;
      ballY[n] = y4;
      ballZ[n] = z4;
      vgm();  
    }

    // Depth sort
    int increment = NUM_BALLS << 2;  // same as: NUM_BALLS / 4

    while (increment > 0) {
      for (int i = increment; i < NUM_BALLS; i++)
      {
        int j = i;
        float tempX = ballX[i];
        float tempY = ballY[i];
        float tempZ = ballZ[i];
        while ((j >= increment) && (ballZ[j-increment] > tempZ))
        {
          ballX[j] = ballX[j - increment];
          ballY[j] = ballY[j - increment];
          ballZ[j] = ballZ[j - increment];
          j = j - increment;
          vgm();
        }
        ballX[j] = tempX;
        ballY[j] = tempY;
        ballZ[j] = tempZ;
        vgm();
      }
      increment = (increment == 2) ? 1: (int)(increment / 2.2); 
      vgm();
    }

    for (byte i = 0; i <50; i++)
    {
      vgm();
    }   

    // Render with perspective
    for (int i=0; i<NUM_BALLS; i++)
    {
      float scale = (ballZ[i] + 3);
      float x = ballX[i] * scale + 155;
      float y = ballY[i] * scale + 100;
      vgm();
      drawBall(x-1,y-1,scale+1, color(0,255,0));
      vgm();
      drawBall(x-1,y-1,scale, color(255,0,0));
      vgm();
      for (byte i = 0; i <50; i++)
      {
        vgm();
      }   
    }

    vgm();
    // Rotate camera
    angx+=0.09;
    angy+=0.03;
    angz+=0.03;

    switchViewPage(page);
    vgm();
  }
  while(--timeDisplacement);
}



