/*

 Name      :  Plasma
 Notes     :  Cycles of changing colours warped to give an illusion of liquid, organic movement.
 
 Precalculated plasma effect values stored in flash rom array.  Colors are the sum of sine functions and various formulas.   

 */

// precalculated colors
PROGMEM prog_char palette[128] = {52,60,60,61,61,126,126,127,127,127,127,127,127,127,127,127,127,127,127,126,126,61,61,60,60,51,51,51,50,50,41,41,40,40,32,32,32,32,24,24,24,24,16,16,17,17,10,10,11,11,12,4,4,5,5,70,70,71,71,71,71,71,71,71,71,71,71,71,71,70,70,5,5,4,4,12,11,11,10,10,17,17,16,16,24,24,24,24,32,32,32,32,40,40,41,41,50,50,51,51,52,60,60,61,61,126,126,127,127,127,127,127,127,127,127,127,127,127,127,126,126,61,61,60,60,51,51,51};

// pre-calcuated lookups converted to uVGA indexed color.  this occupies 6016 bytes of program space
PROGMEM prog_uchar plasmaLUT[94*64] = {127,129,131,133,135,137,139,141,143,145,147,148,150,152,154,156,158,159,161,163,164,166,167,169,170,172,173,175,176,177,178,180,181,182,183,184,185,185,186,187,187,188,189,189,190,190,190,190,191,191,191,191,191,191,190,190,190,189,189,188,188,187,187,186,185,184,183,182,181,180,179,178,177,175,174,173,171,170,168,167,165,164,162,160,158,157,155,153,151,149,148,146,144,142,128,129,131,133,135,137,139,141,143,145,147,149,150,152,154,156,158,159,161,163,164,166,167,169,170,172,173,175,176,177,178,180,181,182,183,184,185,185,186,187,187,188,189,189,190,190,190,190,191,191,191,191,191,191,190,190,190,189,189,188,188,187,186,186,185,184,183,182,181,180,179,178,177,175,174,173,171,170,168,167,165,164,162,160,158,157,155,153,151,149,148,146,144,142,129,130,132,134,135,137,139,141,143,145,147,149,150,152,154,156,158,159,161,163,164,166,167,169,170,172,173,175,176,177,178,180,181,182,183,184,184,185,186,187,187,188,189,189,189,190,190,190,191,191,191,191,191,190,190,190,190,189,189,188,188,187,186,186,185,184,183,182,181,180,179,178,177,175,174,173,171,170,168,167,165,163,162,160,158,157,155,153,151,149,148,146,144,142,130,131,132,134,136,138,139,141,143,145,147,149,151,152,154,156,158,159,161,163,164,166,167,169,170,172,173,175,176,177,178,179,181,182,183,184,184,185,186,187,187,188,189,189,189,190,190,190,190,191,191,191,191,190,190,190,190,189,189,188,188,187,186,186,185,184,183,182,181,180,179,178,176,175,174,172,171,170,168,167,165,163,162,160,158,157,155,153,151,149,147,146,144,142,131,132,133,135,136,138,140,142,143,145,147,149,151,152,154,156,158,159,161,163,164,166,167,169,170,172,173,175,176,177,178,179,181,182,183,183,184,185,186,187,187,188,188,189,189,190,190,190,190,190,191,190,190,190,190,190,189,189,189,188,188,187,186,185,185,184,183,182,181,180,179,178,176,175,174,172,171,169,168,166,165,163,162,160,158,156,155,153,151,149,147,145,143,142,132,133,134,135,137,139,140,142,144,146,147,149,151,153,154,156,158,160,161,163,164,166,167,169,170,172,173,175,176,177,178,179,180,181,182,183,184,185,186,187,187,188,188,189,189,190,190,190,190,190,190,190,190,190,190,190,189,189,188,188,187,187,186,185,184,184,183,182,181,180,179,177,176,175,174,172,171,169,168,166,165,163,161,160,158,156,154,153,151,149,147,145,143,141,132,133,135,136,138,139,141,142,144,146,148,149,151,153,155,156,158,160,161,163,164,166,168,169,170,172,173,175,176,177,178,179,180,181,182,183,184,185,186,186,187,188,188,189,189,189,190,190,190,190,190,190,190,190,190,189,189,189,188,188,187,187,186,185,184,183,183,182,181,179,178,177,176,175,173,172,170,169,168,166,164,163,161,159,158,156,154,152,151,149,147,145,143,141,133,134,135,137,138,140,141,143,145,146,148,150,151,153,155,156,158,160,161,163,164,166,168,169,170,172,173,174,176,177,178,179,180,181,182,183,184,185,186,186,187,188,188,188,189,189,189,190,190,190,190,190,190,190,190,189,189,188,188,188,187,186,186,185,184,183,182,181,180,179,178,177,176,174,173,172,170,169,167,166,164,163,161,159,157,156,154,152,150,148,147,145,143,141,134,135,136,137,139,140,142,143,145,147,148,150,152,153,155,157,158,160,161,163,165,166,168,169,170,172,173,174,176,177,178,179,180,181,182,183,184,185,185,186,187,187,188,188,189,189,189,189,190,190,190,190,190,189,189,189,189,188,188,187,187,186,185,185,184,183,182,181,180,179,178,177,175,174,173,171,170,168,167,165,164,162,161,159,157,155,154,152,150,148,146,144,142,141,135,136,137,138,139,141,142,144,145,147,149,150,152,153,155,157,158,160,161,163,165,166,168,169,170,172,173,174,176,177,178,179,180,181,182,183,184,185,185,186,187,187,188,188,188,189,189,189,189,189,189,189,189,189,189,189,188,188,187,187,186,186,185,184,183,183,182,181,180,179,177,176,175,174,172,171,170,168,167,165,163,162,160,159,157,155,153,151,150,148,146,144,142,140,135,136,137,139,140,141,143,144,146,147,149,150,152,154,155,157,158,160,162,163,165,166,168,169,170,172,173,174,175,177,178,179,180,181,182,183,184,184,185,186,186,187,187,188,188,189,189,189,189,189,189,189,189,189,189,188,188,188,187,187,186,185,185,184,183,182,181,180,179,178,177,176,175,173,172,171,169,168,166,165,163,161,160,158,156,155,153,151,149,147,146,144,142,140,136,137,138,139,141,142,143,145,146,148,149,151,152,154,155,157,159,160,162,163,165,166,168,169,170,172,173,174,175,177,178,179,180,181,182,183,183,184,185,185,186,187,187,188,188,188,188,189,189,189,189,189,189,189,188,188,188,187,187,186,186,185,184,184,183,182,181,180,179,178,177,175,174,173,172,170,169,167,166,164,163,161,159,158,156,154,152,151,149,147,145,143,141,139,136,137,139,140,141,142,144,145,147,148,150,151,153,154,156,157,159,160,162,163,165,166,168,169,170,172,173,174,175,176,177,179,180,181,181,182,183,184,185,185,186,186,187,187,188,188,188,188,188,189,189,188,188,188,188,188,187,187,186,186,185,185,184,183,182,181,180,179,178,177,176,175,174,172,171,170,168,167,165,164,162,161,159,157,156,154,152,150,148,147,145,143,141,139,137,138,139,140,142,143,144,146,147,148,150,151,153,154,156,157,159,160,162,163,165,166,167,169,170,171,173,174,175,176,177,178,179,180,181,182,183,184,184,185,185,186,186,187,187,188,188,188,188,188,188,188,188,188,188,187,187,186,186,185,185,184,183,183,182,181,180,179,178,177,176,175,173,172,171,169,168,166,165,163,162,160,158,157,155,153,151,150,148,146,144,142,140,138,138,139,140,141,142,143,145,146,147,149,150,152,153,155,156,157,159,160,162,163,165,166,167,169,170,171,173,174,175,176,177,178,179,180,181,182,183,183,184,185,185,186,186,187,187,187,187,188,188,188,188,188,188,187,187,187,186,186,185,185,184,184,183,182,181,180,179,178,177,176,175,174,173,171,170,169,167,166,164,163,161,160,158,156,154,153,151,149,147,145,144,142,140,138,138,139,140,141,142,144,145,146,148,149,150,152,153,155,156,158,159,160,162,163,165,166,167,169,170,171,172,174,175,176,177,178,179,180,181,181,182,183,184,184,185,185,186,186,186,187,187,187,187,187,187,187,187,187,187,186,186,185,185,184,184,183,182,182,181,180,179,178,177,176,175,173,172,171,170,168,167,165,164,162,161,159,157,156,154,152,150,149,147,145,143,141,139,137,138,139,140,142,143,144,145,147,148,149,151,152,153,155,156,158,159,160,162,163,165,166,167,169,170,171,172,173,175,176,177,178,179,179,180,181,182,183,183,184,184,185,185,186,186,186,187,187,187,187,187,187,187,186,186,186,185,185,184,184,183,183,182,181,180,179,178,177,176,175,174,173,172,170,169,168,166,165,163,162,160,158,157,155,153,152,150,148,146,144,142,140,139,137,139,140,141,142,143,144,146,147,148,149,151,152,154,155,156,158,159,161,162,163,165,166,167,168,170,171,172,173,174,175,176,177,178,179,180,181,182,182,183,183,184,184,185,185,186,186,186,186,186,186,186,186,186,186,186,185,185,184,184,183,183,182,181,180,180,179,178,177,176,175,173,172,171,170,168,167,165,164,162,161,159,158,156,154,153,151,149,147,145,144,142,140,138,136,139,140,141,142,143,145,146,147,148,150,151,152,154,155,156,158,159,161,162,163,164,166,167,168,170,171,172,173,174,175,176,177,178,179,180,180,181,182,182,183,184,184,184,185,185,185,186,186,186,186,186,186,185,185,185,185,184,184,183,183,182,181,181,180,179,178,177,176,175,174,173,172,170,169,168,166,165,163,162,160,159,157,155,154,152,150,148,147,145,143,141,139,137,135,139,140,141,143,144,145,146,147,149,150,151,152,154,155,156,158,159,160,162,163,164,166,167,168,169,170,172,173,174,175,176,177,178,178,179,180,181,181,182,183,183,184,184,184,185,185,185,185,185,185,185,185,185,185,184,184,184,183,183,182,181,181,180,179,178,177,176,175,174,173,172,171,170,168,167,165,164,163,161,159,158,156,155,153,151,149,148,146,144,142,140,138,136,135,140,141,142,143,144,145,146,147,149,150,151,153,154,155,157,158,159,160,162,163,164,166,167,168,169,170,171,172,173,174,175,176,177,178,179,180,180,181,182,182,183,183,183,184,184,184,184,185,185,185,185,184,184,184,184,183,183,182,182,181,181,180,179,178,178,177,176,175,174,172,171,170,169,167,166,165,163,162,160,159,157,155,154,152,150,149,147,145,143,141,139,138,136,134,140,141,142,143,144,145,146,148,149,150,151,153,154,155,156,158,159,160,162,163,164,165,167,168,169,170,171,172,173,174,175,176,177,178,178,179,180,181,181,182,182,183,183,183,183,184,184,184,184,184,184,184,184,183,183,183,182,182,181,181,180,179,178,178,177,176,175,174,173,172,170,169,168,167,165,164,162,161,159,158,156,155,153,151,150,148,146,144,142,141,139,137,135,133,140,141,142,143,144,145,147,148,149,150,151,153,154,155,156,158,159,160,161,163,164,165,166,167,169,170,171,172,173,174,175,176,176,177,178,179,179,180,181,181,182,182,182,183,183,183,183,183,183,183,183,183,183,183,182,182,181,181,180,180,179,178,178,177,176,175,174,173,172,171,170,168,167,166,164,163,162,160,159,157,155,154,152,150,149,147,145,143,142,140,138,136,134,132,140,141,142,143,144,145,147,148,149,150,151,153,154,155,156,158,159,160,161,163,164,165,166,167,168,169,170,171,172,173,174,175,176,177,178,178,179,179,180,181,181,181,182,182,182,182,183,183,183,183,183,182,182,182,182,181,181,180,180,179,178,178,177,176,175,174,173,172,171,170,169,168,166,165,164,162,161,159,158,156,155,153,151,150,148,146,144,143,141,139,137,135,133,131,140,141,142,143,144,146,147,148,149,150,151,153,154,155,156,158,159,160,161,162,164,165,166,167,168,169,170,171,172,173,174,175,176,176,177,178,178,179,179,180,180,181,181,181,182,182,182,182,182,182,182,182,181,181,181,180,180,179,179,178,178,177,176,175,174,173,172,171,170,169,168,167,165,164,163,161,160,158,157,155,154,152,150,149,147,145,143,142,140,138,136,134,132,130,140,141,142,143,144,146,147,148,149,150,151,153,154,155,156,157,159,160,161,162,163,164,165,167,168,169,170,171,172,173,173,174,175,176,176,177,178,178,179,179,180,180,180,181,181,181,181,181,181,181,181,181,181,180,180,180,179,179,178,177,177,176,175,174,173,173,172,170,169,168,167,166,165,163,162,160,159,157,156,154,153,151,149,148,146,144,142,141,139,137,135,133,131,129,140,141,142,143,144,145,147,148,149,150,151,152,154,155,156,157,158,160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,174,175,176,177,177,178,178,179,179,179,180,180,180,180,180,180,180,180,180,180,180,179,179,179,178,178,177,177,176,175,174,173,173,172,171,170,168,167,166,165,164,162,161,159,158,156,155,153,152,150,148,147,145,143,141,140,138,136,134,132,130,128,140,141,142,143,144,145,146,148,149,150,151,152,153,155,156,157,158,159,160,161,163,164,165,166,167,168,169,170,171,172,172,173,174,175,175,176,177,177,178,178,178,179,179,179,179,180,180,180,180,180,179,179,179,179,178,178,177,177,176,176,175,174,173,173,172,171,170,169,167,166,165,164,163,161,160,158,157,155,154,152,151,149,147,146,144,142,140,139,137,135,133,131,129,127,140,141,142,143,144,145,146,147,149,150,151,152,153,154,156,157,158,159,160,161,162,163,164,165,166,167,168,169,170,171,172,173,173,174,175,175,176,176,177,177,178,178,178,178,179,179,179,179,179,179,179,178,178,178,177,177,176,176,175,175,174,173,172,172,171,170,169,168,166,165,164,163,162,160,159,157,156,154,153,151,150,148,146,145,143,141,139,138,136,134,132,130,128,126,140,141,142,143,144,145,146,147,148,150,151,152,153,154,155,156,157,159,160,161,162,163,164,165,166,167,168,169,170,170,171,172,173,173,174,175,175,176,176,177,177,177,177,178,178,178,178,178,178,178,178,177,177,177,176,176,176,175,174,174,173,172,171,171,170,169,168,167,165,164,163,162,161,159,158,156,155,153,152,150,149,147,145,144,142,140,138,137,135,133,131,129,127,125,140,141,142,143,144,145,146,147,148,149,150,152,153,154,155,156,157,158,159,160,161,162,163,164,165,166,167,168,169,170,171,171,172,173,173,174,174,175,175,176,176,176,177,177,177,177,177,177,177,177,177,177,176,176,175,175,175,174,173,173,172,171,170,170,169,168,167,165,164,163,162,161,159,158,157,155,154,152,151,149,148,146,144,143,141,139,137,135,134,132,130,128,126,124,139,140,141,143,144,145,146,147,148,149,150,151,152,153,155,156,157,158,159,160,161,162,163,164,165,166,167,168,168,169,170,171,171,172,173,173,174,174,175,175,175,176,176,176,176,176,176,176,176,176,176,176,175,175,174,174,174,173,172,172,171,170,169,168,168,167,165,164,163,162,161,160,158,157,156,154,153,151,150,148,146,145,143,141,140,138,136,134,132,131,129,127,125,123,139,140,141,142,143,144,145,146,148,149,150,151,152,153,154,155,156,157,158,159,160,161,162,163,164,165,166,167,168,169,169,170,171,171,172,172,173,173,174,174,174,175,175,175,175,175,175,175,175,175,175,175,174,174,173,173,172,172,171,171,170,169,168,167,166,165,164,163,162,161,160,158,157,156,154,153,152,150,148,147,145,144,142,140,138,137,135,133,131,129,128,126,124,122,139,140,141,142,143,144,145,146,147,148,149,150,152,153,154,155,156,157,158,159,160,161,162,163,164,165,165,166,167,168,169,169,170,171,171,172,172,173,173,173,174,174,174,174,174,174,174,174,174,174,174,174,173,173,172,172,171,171,170,170,169,168,167,166,165,164,163,162,161,160,159,157,156,155,153,152,150,149,147,146,144,142,141,139,137,136,134,132,130,128,126,125,123,121,138,139,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,161,162,163,164,165,166,166,167,168,169,169,170,170,171,171,172,172,172,173,173,173,173,173,173,173,173,173,173,173,173,172,172,171,171,170,170,169,168,168,167,166,165,164,163,162,161,160,159,157,156,155,153,152,151,149,148,146,144,143,141,140,138,136,134,133,131,129,127,125,123,121,120,138,139,140,141,142,143,144,145,146,147,148,150,151,152,153,154,155,156,157,158,159,160,161,162,162,163,164,165,166,166,167,168,168,169,169,170,170,171,171,171,172,172,172,172,172,172,172,172,172,172,172,171,171,171,170,170,169,169,168,167,166,166,165,164,163,162,161,160,159,157,156,155,154,152,151,149,148,146,145,143,142,140,138,137,135,133,131,130,128,126,124,122,120,118,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,161,162,163,163,164,165,166,166,167,167,168,169,169,169,170,170,171,171,171,171,171,171,171,171,171,171,171,171,170,170,170,169,169,168,167,167,166,165,164,164,163,162,161,160,159,157,156,155,154,152,151,150,148,147,145,144,142,140,139,137,135,134,132,130,128,126,125,123,121,119,117,137,138,139,140,141,142,143,144,145,146,147,148,150,151,152,153,154,155,156,157,157,158,159,160,161,162,163,163,164,165,165,166,167,167,168,168,169,169,169,170,170,170,170,170,170,170,170,170,170,170,170,169,169,168,168,167,167,166,166,165,164,163,162,161,160,159,158,157,156,155,154,152,151,150,148,147,145,144,142,141,139,137,136,134,132,131,129,127,125,123,121,120,118,116,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,159,160,161,162,163,163,164,165,165,166,166,167,167,168,168,168,169,169,169,169,169,169,169,169,169,169,169,168,168,168,167,167,166,166,165,164,164,163,162,161,160,159,158,157,156,155,154,152,151,150,148,147,146,144,143,141,139,138,136,134,133,131,129,127,126,124,122,120,118,116,115,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,159,160,161,162,162,163,164,164,165,165,166,166,167,167,167,168,168,168,168,168,168,168,168,168,168,167,167,167,166,166,166,165,164,164,163,162,162,161,160,159,158,157,156,155,154,152,151,150,148,147,146,144,143,141,140,138,136,135,133,131,130,128,126,124,123,121,119,117,115,113,135,136,137,138,139,140,142,143,144,145,146,147,148,149,150,151,152,152,153,154,155,156,157,158,159,159,160,161,161,162,163,163,164,164,165,165,166,166,166,166,167,167,167,167,167,167,167,167,167,166,166,166,165,165,164,164,163,163,162,161,160,159,159,158,157,156,155,153,152,151,150,148,147,146,144,143,141,140,138,137,135,133,132,130,128,127,125,123,121,119,118,116,114,112,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,154,155,156,157,158,158,159,160,161,161,162,162,163,163,164,164,165,165,165,165,166,166,166,166,166,166,166,166,165,165,165,164,164,164,163,163,162,161,161,160,159,158,157,156,155,154,153,152,151,150,148,147,146,144,143,141,140,138,137,135,134,132,130,129,127,125,123,122,120,118,116,114,112,111,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,154,155,156,157,158,158,159,160,160,161,161,162,162,163,163,164,164,164,164,164,165,165,165,165,165,165,164,164,164,164,163,163,162,162,161,161,160,159,158,158,157,156,155,154,153,152,151,150,148,147,146,144,143,142,140,139,137,136,134,132,131,129,127,126,124,122,120,118,117,115,113,111,109,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,154,155,156,157,157,158,159,159,160,160,161,161,162,162,162,163,163,163,163,163,163,164,163,163,163,163,163,163,162,162,162,161,161,160,159,159,158,157,156,155,155,154,153,152,150,149,148,147,146,144,143,142,140,139,137,136,134,133,131,129,128,126,124,122,121,119,117,115,113,112,110,108,133,134,135,136,137,138,139,140,141,142,143,144,145,145,146,147,148,149,150,151,152,153,153,154,155,156,156,157,158,158,159,159,160,160,161,161,161,162,162,162,162,162,162,162,162,162,162,162,162,161,161,161,160,160,159,159,158,157,157,156,155,154,153,152,151,150,149,148,147,145,144,143,142,140,139,137,136,134,133,131,129,128,126,124,123,121,119,117,116,114,112,110,108,106,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,146,147,148,149,150,151,152,152,153,154,155,155,156,157,157,158,158,159,159,159,160,160,160,161,161,161,161,161,161,161,161,161,161,160,160,160,159,159,158,158,157,157,156,155,154,154,153,152,151,150,149,148,146,145,144,143,141,140,139,137,136,134,133,131,130,128,126,125,123,121,120,118,116,114,112,111,109,107,105,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,146,147,148,149,150,151,151,152,153,154,154,155,156,156,157,157,158,158,158,159,159,159,159,160,160,160,160,160,160,160,159,159,159,159,158,158,158,157,156,156,155,155,154,153,152,151,150,149,148,147,146,145,144,143,141,140,139,137,136,134,133,131,130,128,127,125,123,122,120,118,116,115,113,111,109,107,105,104,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,146,147,148,149,150,150,151,152,153,153,154,154,155,155,156,156,157,157,157,158,158,158,158,158,159,159,159,158,158,158,158,158,157,157,157,156,156,155,154,154,153,152,152,151,150,149,148,147,146,145,144,142,141,140,139,137,136,134,133,131,130,128,127,125,123,122,120,118,117,115,113,111,109,108,106,104,102,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,145,146,147,148,149,149,150,151,151,152,153,153,154,154,155,155,156,156,156,157,157,157,157,157,157,157,157,157,157,157,157,156,156,156,155,155,154,154,153,152,152,151,150,149,148,147,146,145,144,143,142,141,140,138,137,136,134,133,131,130,128,127,125,124,122,120,119,117,115,113,112,110,108,106,104,103,101,128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,144,145,146,147,148,148,149,150,150,151,152,152,153,153,154,154,154,155,155,155,156,156,156,156,156,156,156,156,156,155,155,155,155,154,154,153,153,152,152,151,150,149,149,148,147,146,145,144,143,142,141,139,138,137,136,134,133,131,130,128,127,125,124,122,120,119,117,115,114,112,110,108,107,105,103,101,99,127,128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,142,143,144,145,146,146,147,148,149,149,150,150,151,151,152,152,153,153,154,154,154,154,154,155,155,155,155,155,154,154,154,154,154,153,153,152,152,151,151,150,150,149,148,147,146,145,145,144,142,141,140,139,138,137,135,134,133,131,130,128,127,125,124,122,121,119,117,116,114,112,110,109,107,105,103,101,100,98,126,127,128,129,130,131,132,133,134,135,136,137,138,139,140,141,141,142,143,144,145,145,146,147,147,148,149,149,150,150,151,151,152,152,152,153,153,153,153,153,153,153,153,153,153,153,153,152,152,152,151,151,150,150,149,149,148,147,147,146,145,144,143,142,141,140,139,138,136,135,134,133,131,130,128,127,125,124,122,121,119,117,116,114,112,111,109,107,105,104,102,100,98,96,125,126,127,128,129,130,131,132,133,134,135,136,137,138,139,139,140,141,142,143,143,144,145,146,146,147,147,148,149,149,149,150,150,151,151,151,151,152,152,152,152,152,152,152,152,152,151,151,151,150,150,150,149,148,148,147,147,146,145,144,143,142,141,140,139,138,137,136,135,134,132,131,130,128,127,125,124,122,121,119,118,116,114,113,111,109,107,106,104,102,100,99,97,95,124,125,126,127,128,129,130,131,132,133,134,135,136,137,137,138,139,140,141,142,142,143,144,144,145,146,146,147,147,148,148,149,149,149,150,150,150,150,150,151,151,151,151,150,150,150,150,150,149,149,149,148,148,147,146,146,145,144,144,143,142,141,140,139,138,137,136,135,133,132,131,129,128,127,125,124,122,121,119,118,116,114,113,111,109,108,106,104,102,101,99,97,95,93,123,124,125,126,127,128,129,130,131,132,133,134,135,135,136,137,138,139,140,140,141,142,143,143,144,144,145,146,146,147,147,147,148,148,148,149,149,149,149,149,149,149,149,149,149,149,148,148,148,147,147,147,146,146,145,144,144,143,142,141,140,139,138,137,136,135,134,133,132,130,129,128,127,125,124,122,121,119,118,116,114,113,111,110,108,106,104,103,101,99,97,96,94,92,122,123,124,125,126,127,128,129,130,131,132,133,133,134,135,136,137,138,138,139,140,141,141,142,143,143,144,144,145,145,146,146,146,147,147,147,147,148,148,148,148,148,148,148,147,147,147,147,146,146,146,145,145,144,143,143,142,141,141,140,139,138,137,136,135,134,133,131,130,129,128,126,125,124,122,121,119,118,116,115,113,111,110,108,106,105,103,101,99,98,96,94,92,90,121,122,123,124,125,126,127,128,129,130,130,131,132,133,134,135,136,136,137,138,139,139,140,141,141,142,142,143,143,144,144,145,145,145,146,146,146,146,146,146,146,146,146,146,146,146,146,145,145,145,144,144,143,143,142,141,141,140,139,138,137,136,135,134,133,132,131,130,129,127,126,125,123,122,121,119,118,116,115,113,111,110,108,106,105,103,101,100,98,96,94,93,91,89,120,121,122,123,124,125,126,126,127,128,129,130,131,132,133,134,134,135,136,137,137,138,139,139,140,141,141,142,142,143,143,143,144,144,144,144,145,145,145,145,145,145,145,145,145,144,144,144,143,143,143,142,142,141,140,140,139,138,137,137,136,135,134,133,132,131,129,128,127,126,125,123,122,120,119,118,116,115,113,111,110,108,107,105,103,102,100,98,96,95,93,91,89,87,118,119,120,121,122,123,124,125,126,127,128,129,130,131,132,132,133,134,135,135,136,137,137,138,139,139,140,140,141,141,142,142,142,143,143,143,143,143,143,143,143,143,143,143,143,143,143,142,142,142,141,141,140,139,139,138,137,137,136,135,134,133,132,131,130,129,128,127,125,124,123,122,120,119,117,116,114,113,111,110,108,107,105,103,102,100,98,97,95,93,91,90,88,86,117,118,119,120,121,122,123,124,125,126,127,128,129,129,130,131,132,133,133,134,135,136,136,137,137,138,138,139,139,140,140,141,141,141,141,142,142,142,142,142,142,142,142,142,142,141,141,141,140,140,140,139,139,138,137,137,136,135,134,133,133,132,131,130,129,127,126,125,124,123,121,120,119,117,116,114,113,111,110,108,107,105,103,102,100,98,97,95,93,92,90,88,86,85,116,117,118,119,120,121,122,123,124,125,126,126,127,128,129,130,131,131,132,133,134,134,135,135,136,137,137,138,138,138,139,139,140,140,140,140,140,140,141,141,141,141,140,140,140,140,140,139,139,138,138,138,137,136,136,135,134,134,133,132,131,130,129,128,127,126,125,124,122,121,120,118,117,116,114,113,111,110,108,107,105,104,102,100,99,97,95,94,92,90,88,87,85,83,115,116,117,118,119,120,121,122,122,123,124,125,126,127,128,128,129,130,131,131,132,133,133,134,135,135,136,136,137,137,137,138,138,138,139,139,139,139,139,139,139,139,139,139,139,138,138,138,137,137,136,136,135,135,134,133,133,132,131,130,129,128,127,126,125,124,123,122,121,120,118,117,116,114,113,111,110,108,107,105,104,102,100,99,97,95,94,92,90,89,87,85,83,82,113,114,115,116,117,118,119,120,121,122,123,124,125,126,126,127,128,129,129,130,131,131,132,133,133,134,134,135,135,136,136,136,137,137,137,137,137,138,138,138,138,138,137,137,137,137,137,136,136,135,135,134,134,133,133,132,131,130,130,129,128,127,126,125,124,123,122,120,119,118,117,115,114,113,111,110,108,107,105,104,102,100,99,97,96,94,92,91,89,87,85,84,82,80,112,113,114,115,116,117,118,119,120,121,122,123,123,124,125,126,127,127,128,129,129,130,131,131,132,132,133,133,134,134,135,135,135,135,136,136,136,136,136,136,136,136,136,136,136,135,135,135,134,134,133,133,132,132,131,130,130,129,128,127,126,125,124,123,122,121,120,119,118,116,115,114,112,111,110,108,107,105,104,102,101,99,97,96,94,92,91,89,87,86,84,82,80,79};

void plasma(int x, int y, int w, int h){
  byte timeDisplacement=120;     // number of frames to run
  byte page=0;                   // double buffer counter
  do
  {
    page = timeDisplacement & 1; // fast modulo operation using bitwise AND (same as: timeDisplacement % 2)
    switchWritePage(page);
    setupIMG(x,y,w,h);
    int pixelCount = 0;
    for (byte y = 0; y < h; y++) {
      for (byte x = 0; x < w; x++) { 
        vgm();
        VGA_sendCommand(pgm_read_byte(&palette[(pgm_read_byte(&plasmaLUT[pixelCount++])+timeDisplacement)&127]));
      }
    }
    VGA_GetResponse();
    switchViewPage(page);
  }
  while(--timeDisplacement); 
}
