/*

 Name      :  Metaball
 Notes     :  organic-looking n-dimensional objects. 
 
 The technique for rendering metaballs was invented by Jim Blinn in the early 1980s
 
 references:
 http://www.benryves.com/tutorials/blobs/    
 http://www.student.kuleuven.be/~m0216922/CG/index.html
 
 */

void metaball(byte px, byte py, byte w, byte h){
  byte numBlobs = 2;          // two blobby blobs
  byte blob_px[] = {0, 20};   // where blobs will first show
  byte blob_py[] = {10, 0};

  // Movement vector for each blob
  char blob_dx[] = {1, 1};
  char blob_dy[] = {1, 1};

  // build square lookup table
  unsigned int vy[w];
  for (byte i = 0; i < w; i++) {
    vy[i] = sq(i);
  }

  int m = 0;
  byte timeDisplacement=140;     // number of frames to run
  byte page=0;

  do
  {
    page = timeDisplacement & 1; // fast modulo operation using bitwise AND (same as: timeDisplacement % 2)
    switchWritePage(page);       // double buffer it

    for (byte i=0; i<numBlobs; ++i) {
      blob_px[i]+=blob_dx[i];
      blob_py[i]+=blob_dy[i];

      // bounce across screen
      if (blob_px[i] <= 0) {
        blob_dx[i] = 1;
      }
      if (blob_px[i] >= w-1-5) {
        blob_dx[i] = -1;
      }
      if (blob_py[i] <= 5) {
        blob_dy[i] = 1;
      }
      if (blob_py[i] >= h-1-5) {
        blob_dy[i]=-1;
      }
    }

    setupIMG(px,py,w,h);
    for (byte y = 0; y < h; y++) {
      for (byte x = 0; x < w; x++) { 
        m = 1;
        for (byte i = 0; i < numBlobs; i++) {
          // Increase 10K number to make your blobs bigger 
          m += 10000/(vy[abs(blob_px[i]-x)] + vy[abs(blob_py[i]-y)]+1);
        }
        vgm();
        if (m>255) m=255; // this prevents center of metballs from junking up (overflowed colors)
        VGA_sendCommand(color(0,m,m));
      }
    }
    VGA_GetResponse();
    switchViewPage(page);
  }
  while(--timeDisplacement);
}





