/*

 Name      :  3D Cube
 Notes     :  wireframe cube spinning in space
 
 3dline code from Ben Ryves' ASCII Madness II DEMO.  Modified for speed.
 Using uVGA's built-in line functions and external FPU to get rotation values.
 
 references:
 http://www.benryves.com/products/am2
 
 */

double sin_rot_x;
double sin_rot_y;
double cos_rot_x;
double cos_rot_y;

void cube(){
  float rot_x = 0;                 // x axis spin
  float rot_y = 0;                 // y axis spin
  byte page=0;                     // double buffer counter
  byte timeDisplacement=200;       // number of frames to run

  do
  {
    page = timeDisplacement & 1;   // fast modulo operation using bitwise AND (same as: timeDisplacement % 2)
    switchWritePage(page);

    rect(107,68,200,131,0);        // erase monitor with black background

    sin_rot_x = fpu_sin(rot_x);
    sin_rot_y = fpu_sin(rot_y);
    cos_rot_x = fpu_cos(rot_x);
    cos_rot_y = fpu_cos(rot_y);

    draw_3D_line(-15,-15,-15, 15,-15,-15);
    draw_3D_line( 15,-15,-15, 15, 15,-15);
    draw_3D_line( 15, 15,-15,-15, 15,-15);
    draw_3D_line(-15, 15,-15,-15,-15,-15);
    draw_3D_line(-15,-15, 15, 15,-15, 15);
    draw_3D_line( 15,-15, 15, 15, 15, 15);
    draw_3D_line( 15, 15, 15,-15, 15, 15);
    draw_3D_line(-15, 15, 15,-15,-15, 15);
    draw_3D_line(-15,-15, 15,-15,-15,-15);
    draw_3D_line( 15,-15, 15, 15,-15,-15);
    draw_3D_line( 15, 15, 15, 15, 15,-15);
    draw_3D_line(-15, 15, 15,-15, 15,-15);

    rot_x+=0.04;
    rot_y+=0.02;

    switchViewPage(page);
  }  
  while(--timeDisplacement);
}

void draw_3D_line(float x1, float y1, float z1, float x2, float y2, float z2){
  double x_p[2] = {
    x1, x2  };
  double y_p[2] = {
    y1, y2  };
  double z_p[2] = {
    z1, z2  };
  int scrX[2];
  int scrY[2];

  for (byte i = 0; i <200; i++)
  {
    vgm();
  }   

  for (int i=0; i<2; ++i){
    double rotX1 = -x_p[i] * sin_rot_x + y_p[i] * cos_rot_x;
    double rotY1 = -x_p[i] * cos_rot_x * sin_rot_y - y_p[i] * sin_rot_x * sin_rot_y - z_p[i] * cos_rot_y;
    double rotZ1 = -x_p[i] * cos_rot_x * cos_rot_y - y_p[i] * sin_rot_x * cos_rot_y + z_p[i] * sin_rot_y;

    // change 300 to scale the cube bigger or smaller
    scrX[i] = (int)(300 * (rotX1 / (rotZ1 + 256)) + 155);
    scrY[i] = (int)(300 * (rotY1 / (rotZ1 + 256)) + 100);
  }
  line(scrX[0],scrY[0],scrX[1],scrY[1],255);
}




