#include "VuvuzelaHero.h"

#include "SceneBase.h"

#include <QtGui/QLabel>
#include <QtGui/QMenu>
#include <QtGui/QMenuBar>
#include <QtGui/QAction>

VuvuzelaHero::VuvuzelaHero() : m_scene(0)
{
    setAutoFillBackground(false);   
}

VuvuzelaHero::~VuvuzelaHero()
{

}

void VuvuzelaHero::setScene ( SceneBase* scene )
{
    if(m_scene){
        m_scene->stop();
        delete m_scene;
    }
    m_scene = scene;
    m_scene->vuvuzelaHero = this;
    m_scene->start();
}

bool VuvuzelaHero::initialize()
{
    if(!(menubg = bindTexture(QImage("data/menubg.png")))){
        qErrnoWarning("Failed to load data/menubg.png");
        return false;
    }
    if(!(logo = bindTexture(QImage("data/logo.png")))){
        qErrnoWarning("Failed to load data/logo.png");
        return false;
    }
    if(!(grass = bindTexture(QImage("data/grass.png")))){
        qErrnoWarning("Failed to load data/grass.png");
        return false;
    }
    if(!(shadow = bindTexture(QImage("data/shadow.png")))){
        qErrnoWarning("Failed to load data/shadow.png");
        return false;
    }
    
    #ifndef SDLAUDIO
    noise = Phonon::createPlayer(Phonon::MusicCategory, Phonon::MediaSource("data/noise.wav"));
    connect(noise, SIGNAL(aboutToFinish()), this, SLOT(continueNoise()));
    #else
    noise = new SDLAudioObject(this);
    if(!noise->load("data/noise.wav")){
        qErrnoWarning("Failed to load data/noise.wav");
        return false;
    }
    #endif
    
    
    double degrad = (M_PI/180.0);
    //Construct vuvuzela model
    for(int part = 0; part < 32; ++part){
        double rad = 1.0 / (1.0 + 0.25 * part);
        double yval = -part / 12.0;
        for(float pos = 0; pos < 360; pos += 5.625){

            VecNor v1;
            v1.vector = QVector3D(rad * cos((pos) * degrad) * 0.5, rad * sin((pos) * degrad) * 0.5, yval);
            m_vuvuzelaVertices.append(v1);
        }
    }
    for(int part = 0; part < 31; ++part){
        for(int pos = 0; pos < 63; ++pos){
            QList<int> l1;
            l1.append(part * 64 + pos);
            l1.append((part + 1) * 64 + pos);
            l1.append(part * 64 + pos + 1);
            
            m_vuvuzelaTriangles.append(l1);
            
            QList<int> l2;
            l2.append((part + 1) * 64 + pos + 1);
            l2.append(part * 64 + pos + 1);
            l2.append((part + 1) * 64 + pos);
            
            m_vuvuzelaTriangles.append(l2);
        }
        
        QList<int> l1;
        l1.append(part * 64 + 63);
        l1.append((part + 1) * 64 + 63);
        l1.append(part * 64);
        
        m_vuvuzelaTriangles.append(l1);
        QList<int> l2;
        l2.append((part + 1) * 64);
        l2.append(part * 64);
        l2.append((part + 1) * 64 + 63);
        
        m_vuvuzelaTriangles.append(l2);
    }
    
    QList<QList<int> >::iterator it = m_vuvuzelaTriangles.begin();
    while(it != m_vuvuzelaTriangles.end()){
        QList<int>& vs = *it;
        VecNor& point1 = m_vuvuzelaVertices[vs[0]];
        VecNor& point2 = m_vuvuzelaVertices[vs[1]];
        VecNor& point3 = m_vuvuzelaVertices[vs[2]];
        
        QVector3D v1 = point1.vector - point2.vector;
        QVector3D v2 = point2.vector - point3.vector;
        
        QVector3D v = QVector3D::crossProduct(v1, v2);
        v.normalize();
        m_vuvuzelaNormals.append(v);
        ++it;
    }
    int num = 0;
    int numFaces = 0;
    QList<VecNor>::iterator it2 = m_vuvuzelaVertices.begin();
    while(it2 != m_vuvuzelaVertices.end()){
        VecNor& vn = *it2;
        
        
        int num2 = 0;
        it = m_vuvuzelaTriangles.begin();
        while(it != m_vuvuzelaTriangles.end()){
            QList<int>& vs = *it;
            if(vs[0] == num || vs[1] == num || vs[2] == num){
                vn.normal += m_vuvuzelaNormals[num2];
                ++numFaces;
            }
            ++num2;
            ++it;
        }
        
        vn.normal /= numFaces;
        vn.normal.normalize();
        
        ++num;
        ++it2;
    }
    
    return true;
}

void VuvuzelaHero::paintVuvuzela()
{
    glBegin(GL_TRIANGLES);
    QList<QList<int> >::iterator it = m_vuvuzelaTriangles.begin();
    QList<QVector3D >::iterator it2 = m_vuvuzelaNormals.begin();
    while(it != m_vuvuzelaTriangles.end()){
        
        VecNor v1 = m_vuvuzelaVertices[(*it)[0]];
        glNormal3f(v1.normal.x(), v1.normal.y(), v1.normal.z());
        glVertex3f(v1.vector.x(), v1.vector.y(), v1.vector.z());
        
        VecNor v2 = m_vuvuzelaVertices[(*it)[1]];
        glNormal3f(v2.normal.x(), v2.normal.y(), v2.normal.z());
        glVertex3f(v2.vector.x(), v2.vector.y(), v2.vector.z());
        
        VecNor v3 = m_vuvuzelaVertices[(*it)[2]];
        glNormal3f(v3.normal.x(), v3.normal.y(), v3.normal.z());
        glVertex3f(v3.vector.x(), v3.vector.y(), v3.vector.z());
        
        
        ++it;
        ++it2;
    }
    
    glEnd();
}


void VuvuzelaHero::drawText(QPainter& p, const QPoint& point, const QString& text){
    p.setPen(QPen(QColor(0,0,0)));
    p.drawText(point + QPointF(3,3), text);
    p.setPen(QPen(QColor(167,19,19)));
    p.drawText(point, text);
}


void VuvuzelaHero::timeout()
{
    updateGL();
}

void VuvuzelaHero::keyPressEvent(QKeyEvent* e)
{
    
    m_scene->keyPressEvent(e);
}
void VuvuzelaHero::keyReleaseEvent(QKeyEvent* e)
{
    
    m_scene->keyReleaseEvent(e);
}

void VuvuzelaHero::continueNoise()
{
    #ifndef SDLAUDIO
    noise->enqueue(Phonon::MediaSource("data/noise.wav"));
    #endif
}



void VuvuzelaHero::paintGL(){
    
    m_scene->paint(size());
}

#include "VuvuzelaHero.moc"
