varying vec4 diffuse;
varying vec3 lightDir, halfVector;
varying float alpha;

void main() {	
	// first transform the normal into eye space and normalize the result
	//normal = normalize(gl_NormalMatrix * gl_Normal);
	
	// now normalize the light's direction. Note that according to the OpenGL specification, the light is stored in eye space. Also since we're talking about a directional light, the position field is actually direction
	lightDir = normalize(vec3(gl_LightSource[0].position));

	// Normalize the halfVector to pass it to the fragment shader
	halfVector = normalize(gl_LightSource[0].halfVector.xyz);
				
	// Compute the diffuse, ambient and globalAmbient terms
	diffuse = gl_Color * gl_LightSource[0].diffuse;
	alpha = gl_Color.a;

	gl_TexCoord[0] = gl_MultiTexCoord0;
	gl_Position = ftransform();
} 
