uniform float uTimer;
uniform vec3 uColor1;
uniform vec3 uColor2;
uniform sampler2D uTexture;
uniform sampler2D uPlasmaTexture;

void main() {
	vec2 coordinate = gl_TexCoord[0].xy;
	float distance = texture2D(uTexture, coordinate).r;

	vec2 coordinate2 = gl_TexCoord[1].xy;

	float timer = uTimer * 1.0;
	vec2 offset1 = 0.5 * (1.0 + vec2(sin(timer * 1.0), cos(timer * 1.1)));
	vec2 offset2 = 0.5 * (1.0 + vec2(sin(timer * 0.9), cos(timer * 0.85)));
	vec2 offset3 = 0.5 * (1.0 + vec2(cos(timer * 1.1), sin(timer * 1.05)));
	float size = texture2D(uPlasmaTexture, 0.5 * (coordinate2 + offset1)).r +
	              texture2D(uPlasmaTexture, 0.5 * (coordinate2 + offset2)).r +
	              texture2D(uPlasmaTexture, 0.5 * (coordinate2 + offset3)).r;
	float checkDistance = cos(size * 5.0) * 0.3 + 0.4;

	float inside = clamp((checkDistance - distance) * 10.0, 0.0, 1.0);
	vec4 color1 = vec4(uColor1, 1.0);
	vec4 color2 = vec4(uColor2, 1.0);
	gl_FragColor = mix(color1, color2, inside);
}
