/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import lonelycoders.ufohippa.general.Logger;
import lonelycoders.ufohippa.util.ResourceNotFoundException;

public final class ResourceUtil {
    public static InputStream getResource(String resourceName) {
        InputStream is = ResourceUtil.class.getClassLoader().getResourceAsStream(resourceName);
        if (is == null) {
            throw new ResourceNotFoundException(resourceName);
        }
        return is;
    }

    public static byte[] getResourceBytes(String resourceName) {
        InputStream is = ResourceUtil.class.getClassLoader().getResourceAsStream(resourceName);
        assert (is != null) : resourceName;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        try {
            int length;
            while ((length = is.read(buffer)) != -1) {
                bos.write(buffer, 0, length);
            }
            is.close();
            bos.close();
        }
        catch (IOException e) {
            Logger.exception(e);
        }
        return bos.toByteArray();
    }

    public static String getResourceText(String resourceName) {
        BufferedReader br = new BufferedReader(new InputStreamReader(ResourceUtil.getResource(resourceName)));
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(line).append('\n');
            }
            br.close();
        }
        catch (IOException e) {
            Logger.exception(e);
        }
        return sb.toString();
    }
}

