/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.server.states.match;

import lonelycoders.ufohippa.game.InputStatus;
import lonelycoders.ufohippa.game.PlayerAction;
import lonelycoders.ufohippa.network.CommandHandler;
import lonelycoders.ufohippa.network.CommandState;
import lonelycoders.ufohippa.network.State;
import lonelycoders.ufohippa.network.commands.match.EndRoundReplyCommand;
import lonelycoders.ufohippa.network.commands.match.KeyUpdateCommand;
import lonelycoders.ufohippa.network.commands.match.StartRoundCommand;
import lonelycoders.ufohippa.network.commands.match.StartRoundReplyCommand;
import lonelycoders.ufohippa.server.ServerCommunicator;
import lonelycoders.ufohippa.server.SharedContext;
import lonelycoders.ufohippa.server.states.match.RoundStartInfo;

public class ServerRoundState
extends CommandState {
    private final ServerCommunicator serverCommander;
    private final State nextState;
    private static final Object START_ROUND = "START_ROUND";
    private final CommandHandler startRoundReplyHandler = new StartRoundReplyCommand.Handler(){

        @Override
        public State process(StartRoundReplyCommand payload) {
            ServerRoundState.this.serverCommander.synchronize(START_ROUND, new Runnable(){

                @Override
                public void run() {
                    ServerRoundState.this.serverCommander.getSharedContext().startRound();
                }
            });
            return null;
        }
    };
    private final CommandHandler keyUpdateHandler = new KeyUpdateCommand.Handler(){

        @Override
        public State process(KeyUpdateCommand payload) {
            for (InputStatus status : payload.getStatusUpdates()) {
                int playerIndex = status.getAction().getPlayerIndex();
                String[] clientPlayers = ServerRoundState.this.serverCommander.getClientPlayers();
                if (playerIndex < 0 || playerIndex >= clientPlayers.length) continue;
                PlayerAction action = status.getAction().getAction();
                boolean pressed = status.isPressed();
                String playerName = clientPlayers[playerIndex];
                ServerRoundState.this.serverCommander.getSharedContext().handlePlayerAction(playerName, action, pressed);
            }
            return null;
        }
    };
    private final CommandHandler endRoundReplyHandler = new EndRoundReplyCommand.Handler(){

        @Override
        public State process(EndRoundReplyCommand payload) {
            return ServerRoundState.this.nextState;
        }
    };

    public ServerRoundState(ServerCommunicator serverCommander, State nextState) {
        super("Round", new CommandHandler[0]);
        this.serverCommander = serverCommander;
        this.nextState = nextState;
        this.registerHandlers(this.startRoundReplyHandler, this.keyUpdateHandler, this.endRoundReplyHandler);
    }

    private void startRound(int roundNumber) {
        SharedContext sharedContext = this.serverCommander.getSharedContext();
        RoundStartInfo startInfo = sharedContext.getStartInfo();
        this.sendCommand(new StartRoundCommand(roundNumber, sharedContext.getMatch().getCurrentLevel().getName(), startInfo.getStartingPositions(), startInfo.getStartTag()));
    }

    @Override
    public void setActive(boolean active) {
        super.setActive(active);
        if (active) {
            this.startRound(this.serverCommander.getSharedContext().getMatch().getRoundNumber());
        }
    }
}

