/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.server.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lonelycoders.ufohippa.game.RoundResults;
import lonelycoders.ufohippa.game.level.LevelDescriptor;
import lonelycoders.ufohippa.server.model.PlayerInfo;

public class ServerMatch {
    private final LevelDescriptor[] levels;
    private int currentRound = 0;
    private final Map<String, Integer> points = new HashMap<String, Integer>();

    public ServerMatch(Collection<LevelDescriptor> levels) {
        ArrayList<LevelDescriptor> shuffledLevels = new ArrayList<LevelDescriptor>(levels);
        Collections.shuffle(shuffledLevels);
        this.levels = shuffledLevels.toArray(new LevelDescriptor[shuffledLevels.size()]);
    }

    public void resetPoints(List<PlayerInfo> players) {
        for (PlayerInfo player : players) {
            this.points.put(player.getName(), 0);
        }
    }

    public LevelDescriptor[] getLevels() {
        return this.levels;
    }

    public LevelDescriptor getCurrentLevel() {
        return this.levels[this.currentRound];
    }

    public void nextRound() {
        ++this.currentRound;
    }

    public Map<String, Integer> getPoints() {
        return new HashMap<String, Integer>(this.points);
    }

    public void applyResults(RoundResults roundResults) {
        for (Map.Entry<String, Integer> entry : roundResults.getAddedPlayerPoints().entrySet()) {
            String playerName = entry.getKey();
            Integer oldPoints = this.points.get(playerName);
            Integer newPoints = entry.getValue();
            this.points.put(playerName, oldPoints + newPoints);
        }
    }

    public int getRoundNumber() {
        return this.currentRound;
    }
}

