/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.server.model;

public class BasicSettings {
    public static final int MAX_HUMAN_PLAYER_COUNT = 12;
    public static final int MAX_AI_PLAYERS = 4;
    public static final int MAX_PLAYER_COUNT = 16;
    private static final int MAX_PLAYING_TIME = 10;
    private final int maxPlayers;
    private final int playingTime;
    private final int aiPlayers;
    private final boolean bonusItems;
    private final boolean publicGame;
    private final boolean allowJoiningDuringGame;

    public BasicSettings(int maxPlayers, int playingTime, int aiPlayers, boolean bonusItems, boolean publicGame, boolean allowJoiningDuringGame) {
        this.maxPlayers = Math.max(1, Math.min(12, maxPlayers));
        this.playingTime = Math.max(1, Math.min(10, playingTime));
        this.aiPlayers = Math.max(0, Math.min(4, aiPlayers));
        this.bonusItems = bonusItems;
        this.publicGame = publicGame;
        this.allowJoiningDuringGame = allowJoiningDuringGame;
    }

    public BasicSettings() {
        this(8, 3, 0, false, false, false);
    }

    public BasicSettings newMaxPlayers(int maxPlayers) {
        return new BasicSettings(maxPlayers, this.playingTime, this.aiPlayers, this.bonusItems, this.publicGame, this.allowJoiningDuringGame);
    }

    public BasicSettings newPlayingTime(int playingTime) {
        return new BasicSettings(this.maxPlayers, playingTime, this.aiPlayers, this.bonusItems, this.publicGame, this.allowJoiningDuringGame);
    }

    public BasicSettings newNumberOfAIPlayers(int aiPlayers) {
        return new BasicSettings(this.maxPlayers, this.playingTime, aiPlayers, this.bonusItems, this.publicGame, this.allowJoiningDuringGame);
    }

    public BasicSettings newBonusItems(boolean bonusItems) {
        return new BasicSettings(this.maxPlayers, this.playingTime, this.aiPlayers, bonusItems, this.publicGame, this.allowJoiningDuringGame);
    }

    public BasicSettings newPublicGame(boolean publicGame) {
        return new BasicSettings(this.maxPlayers, this.playingTime, this.aiPlayers, this.bonusItems, publicGame, this.allowJoiningDuringGame);
    }

    public BasicSettings newAllowJoiningDuringGame(boolean allowJoiningDuringGame) {
        return new BasicSettings(this.maxPlayers, this.playingTime, this.aiPlayers, this.bonusItems, this.publicGame, allowJoiningDuringGame);
    }

    public int getMaxPlayers() {
        return this.maxPlayers;
    }

    public int getPlayingTime() {
        return this.playingTime;
    }

    public int getAiPlayers() {
        return this.aiPlayers;
    }

    public boolean isBonusItems() {
        return this.bonusItems;
    }

    public boolean isPublicGame() {
        return this.publicGame;
    }

    public boolean isAllowJoiningDuringGame() {
        return this.allowJoiningDuringGame;
    }
}

