/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.server;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lonelycoders.ufohippa.game.PlayerAction;
import lonelycoders.ufohippa.game.RoundResults;
import lonelycoders.ufohippa.game.ai.AIController;
import lonelycoders.ufohippa.game.level.LevelDescriptor;
import lonelycoders.ufohippa.game.ufo.Ufo;
import lonelycoders.ufohippa.game.util.Vector2;
import lonelycoders.ufohippa.network.commands.match.EndRoundCommand;
import lonelycoders.ufohippa.network.commands.match.RoundUpdateCommand;
import lonelycoders.ufohippa.server.GameRunner;
import lonelycoders.ufohippa.server.ServerGame;
import lonelycoders.ufohippa.server.ServerRound;
import lonelycoders.ufohippa.server.SharedContextCommander;
import lonelycoders.ufohippa.server.UpdateInfo;
import lonelycoders.ufohippa.server.UpdateListener;
import lonelycoders.ufohippa.server.model.AllServerSettings;
import lonelycoders.ufohippa.server.model.BasicSettings;
import lonelycoders.ufohippa.server.model.PlayerInfo;
import lonelycoders.ufohippa.server.model.ServerMatch;
import lonelycoders.ufohippa.server.states.match.RoundStartInfo;

public class SharedContext {
    private ServerMatch serverMatch;
    private List<PlayerInfo> players;
    private BasicSettings basicSettings;
    private GameRunner gameRunner;
    private ServerGame serverGame;
    private final Map<PlayerAction, Ufo.Control> controls = new EnumMap<PlayerAction, Ufo.Control>(PlayerAction.class);
    private RoundStartInfo startInfo;
    private RoundResults roundResults;
    private final UpdateListener updateListener = new UpdateListener(){
        private volatile int currentTimeStamp = 0;
        private volatile int sentTimeStamp = 0;

        @Override
        public void roundUpdated(ServerRound round, UpdateInfo updateInfo) {
            if (this.currentTimeStamp == this.sentTimeStamp) {
                SharedContext.this.commander.broadcastCommand(new RoundUpdateCommand(updateInfo){
                    int timeStamp;
                    {
                        this.timeStamp = ++currentTimeStamp;
                    }

                    @Override
                    public void serialize(DataOutputStream dos) throws IOException {
                        super.serialize(dos);
                        sentTimeStamp = this.timeStamp;
                    }
                });
            }
        }
    };
    private final ServerRound.RoundListener roundListener = new ServerRound.RoundListener(){

        @Override
        public void roundFinished(Map<Ufo, Double> tagTimes) {
            HashMap<String, Double> playerTagTimes = new HashMap<String, Double>();
            for (Map.Entry<Ufo, Double> entry : tagTimes.entrySet()) {
                playerTagTimes.put(entry.getKey().getPlayerName(), entry.getValue());
            }
            SharedContext.this.roundResults = RoundResults.createRoundResults(SharedContext.this.serverMatch.getPoints(), playerTagTimes);
            SharedContext.this.serverMatch.applyResults(SharedContext.this.roundResults);
            SharedContext.this.stopRound();
            SharedContext.this.commander.broadcastCommand(new EndRoundCommand(playerTagTimes));
        }
    };
    private final SharedContextCommander commander;

    public SharedContext(SharedContextCommander commander) {
        this.controls.put(PlayerAction.LEFT, Ufo.Control.LEFT);
        this.controls.put(PlayerAction.RIGHT, Ufo.Control.RIGHT);
        this.controls.put(PlayerAction.UP, Ufo.Control.UP);
        this.controls.put(PlayerAction.DOWN, Ufo.Control.DOWN);
        this.controls.put(PlayerAction.ACTION, Ufo.Control.FIRE);
        this.commander = commander;
    }

    public void startGame(AllServerSettings allServerSettings) {
        this.serverMatch = new ServerMatch(allServerSettings.getLevels());
        this.players = allServerSettings.getPlayers();
        this.serverMatch.resetPoints(this.players);
        this.basicSettings = allServerSettings.getBasicSettings();
    }

    public void initializeNextRound() {
        LevelDescriptor level = this.serverMatch.getLevels()[this.serverMatch.getRoundNumber()];
        level.load();
        List<PlayerInfo> players = this.getPlayers();
        this.startInfo = new RoundStartInfo(level, players);
    }

    public boolean hashMoreRounds() {
        return this.serverMatch.getRoundNumber() < this.serverMatch.getLevels().length;
    }

    public void startRound() {
        this.serverGame = new ServerGame(this.roundListener);
        LevelDescriptor level = this.serverMatch.getCurrentLevel();
        Vector2[] startingPositions = this.startInfo.getStartingPositions();
        int i = 0;
        for (PlayerInfo player : this.players) {
            Ufo ufo = new Ufo(player.getName(), startingPositions[i], player.isAiPlayer());
            AIController aiController = player.getAiController();
            this.serverGame.addUfo(ufo);
            if (aiController != null) {
                this.serverGame.addAI(aiController, ufo);
            }
            ++i;
        }
        ServerRound round = this.serverGame.initializeRound(level.load(), this.basicSettings.getPlayingTime());
        round.setTagUfo(this.serverGame.getUfo(this.startInfo.getStartTag()));
        this.gameRunner = new GameRunner(this.serverGame);
        this.gameRunner.addUpdateListener(this.updateListener);
        this.gameRunner.start();
    }

    public void stopRound() {
        this.serverMatch.nextRound();
        this.gameRunner.stop();
    }

    public ServerMatch getMatch() {
        return this.serverMatch;
    }

    public List<PlayerInfo> getPlayers() {
        return this.players;
    }

    public void handlePlayerAction(String playerName, PlayerAction action, boolean pressed) {
        Ufo ufo = this.serverGame.getUfo(playerName);
        ufo.setControlState(this.controls.get((Object)action), pressed);
    }

    public RoundStartInfo getStartInfo() {
        return this.startInfo;
    }

    public BasicSettings getBasicSettings() {
        return this.basicSettings;
    }

    public RoundResults getRoundResults() {
        return this.roundResults;
    }
}

