/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import lonelycoders.ufohippa.game.Round;
import lonelycoders.ufohippa.game.level.Level;
import lonelycoders.ufohippa.game.level.LevelUtil;
import lonelycoders.ufohippa.game.level.Teleport;
import lonelycoders.ufohippa.game.ufo.Bullet;
import lonelycoders.ufohippa.game.ufo.Ufo;
import lonelycoders.ufohippa.game.util.Vector2;
import lonelycoders.ufohippa.network.commands.match.RoundUpdateCommand;
import lonelycoders.ufohippa.server.UpdateInfo;

public class ServerRound
extends Round {
    private final RoundListener listener;
    private int bulletId = 0;
    private UpdateInfo updateInfo;
    static int i = 0;

    public ServerRound(Level level, Collection<Ufo> ufos, int playingTime, RoundListener listener) {
        super(level, ufos, playingTime);
        this.listener = listener;
    }

    public void update(double deltaTime, UpdateInfo updateInfo) {
        this.updateInfo = updateInfo;
        super.update(deltaTime);
        if (this.remainingTime == 0.0) {
            HashMap<Ufo, Double> tagTimes = new HashMap<Ufo, Double>();
            for (Map.Entry entry : this.tagTimes.entrySet()) {
                tagTimes.put((Ufo)entry.getKey(), (Double)entry.getValue());
            }
            this.listener.roundFinished(tagTimes);
        }
    }

    @Override
    protected void updateOnce() {
        for (Ufo ufo : this.ufos) {
            boolean[] controls = new boolean[Ufo.Control.values().length];
            for (int i = 0; i < controls.length; ++i) {
                controls[i] = ufo.getControlState(Ufo.Control.values()[i]);
            }
            this.updateInfo.addPlayerData(new RoundUpdateCommand.PlayerData(ufo.getPlayerName(), new Vector2(ufo.getPosition()), new Vector2(ufo.getVelocity()), controls));
            if (ufo.getControlState(Ufo.Control.FIRE)) {
                ufo.setControlState(Ufo.Control.FIRE, false);
                Bullet bullet = ufo.shoot();
                if (bullet != null) {
                    int bulletId;
                    ++this.bulletId;
                    this.addBullet(bulletId, bullet);
                    this.updateInfo.bulletShot(new RoundUpdateCommand.BulletShootData(bulletId, ufo.getPlayerName(), bullet.getBounceProbability(), bullet.getPosition(), bullet.getVelocity()));
                }
            }
            this.checkUfoTeleports(ufo);
            this.checkBulletUfoCollisions();
        }
    }

    private void checkUfoTeleports(Ufo ufo) {
        for (Teleport teleport : this.level.getTeleports()) {
            this.checkUfoTeleport(teleport, ufo);
        }
    }

    private void checkUfoTeleport(Teleport teleport, Ufo ufo) {
        Vector2 teleportPosition = new Vector2(teleport.getX(), teleport.getY());
        teleportPosition.add(new Vector2(0.5f, 0.5f));
        Vector2 ufoPosition = ufo.getPosition();
        Vector2 positionDelta = new Vector2(teleportPosition.x - ufoPosition.x, teleportPosition.y - ufoPosition.y);
        Vector2 scaledPositionDelta = new Vector2(positionDelta);
        Vector2 divider = new Vector2(Ufo.DIAMETER);
        divider.scale(0.5f);
        divider.add(new Vector2(0.5f, 0.5f));
        scaledPositionDelta.divide(divider);
        float testDot = scaledPositionDelta.getLength2();
        if (testDot < 1.0f && ufo.teleport()) {
            Vector2 targetPosition = this.getTeleportTarget(teleport);
            switch (teleport.getType()) {
                case NORMAL: {
                    targetPosition.sub(new Vector2(teleport.getX(), teleport.getY()));
                    ufo.getPosition().add(targetPosition);
                    break;
                }
                case ANYWHERE: {
                    ufo.setPosition(targetPosition);
                }
            }
            this.updateInfo.addSoundEffect(UpdateInfo.SoundEffect.TELEPORT);
            this.updateInfo.setTeleported();
        }
    }

    private Vector2 getTeleportTarget(Teleport teleport) {
        if (teleport.getType() == Teleport.Type.NORMAL) {
            ArrayList<Teleport> validTargets = new ArrayList<Teleport>();
            for (Teleport testTeleport : this.level.getTeleports()) {
                if (testTeleport == teleport || testTeleport.getType() != Teleport.Type.NORMAL) continue;
                validTargets.add(testTeleport);
            }
            Teleport targetTeleport = (Teleport)validTargets.get((int)(Math.random() * (double)validTargets.size()));
            return new Vector2(targetTeleport.getX(), targetTeleport.getY());
        }
        if (teleport.getType() == Teleport.Type.ANYWHERE) {
            Set<LevelUtil.TilePosition> availablePositions = this.level.getAvailablePositions();
            LevelUtil.TilePosition[] availablePositionsArray = availablePositions.toArray(new LevelUtil.TilePosition[availablePositions.size()]);
            LevelUtil.TilePosition position = availablePositionsArray[(int)(Math.random() * (double)availablePositionsArray.length)];
            return new Vector2((float)position.getX() + 0.5f, (float)position.getY() + 0.5f);
        }
        throw new IllegalStateException();
    }

    @Override
    protected void ufosCollided(Ufo ufo1, Ufo ufo2, float strength) {
        Ufo newTag = null;
        if (!this.isSafeTag()) {
            if (this.tagUfo == ufo1) {
                newTag = ufo2;
            } else if (this.tagUfo == ufo2) {
                newTag = ufo1;
            }
        }
        if (newTag != null) {
            this.setTagUfo(newTag);
            this.updateInfo.setTagChanged();
        }
        assert (ufo1 != null);
        assert (ufo2 != null);
        this.updateInfo.ufosCollided(new RoundUpdateCommand.UfoCollision(ufo1.getPlayerName(), ufo2.getPlayerName(), newTag != null ? newTag.getPlayerName() : null, strength));
    }

    @Override
    protected void ufoCollided(Ufo ufo, float strength) {
        if ((double)strength > 0.3) {
            this.updateInfo.addSoundEffect(UpdateInfo.SoundEffect.WALL_COLLISION);
        }
    }

    @Override
    protected void bulletDestroyed(int bulletId, Ufo ufo) {
        super.bulletDestroyed(bulletId, ufo);
        this.bullets.remove(bulletId);
        this.updateInfo.bulletHit(new RoundUpdateCommand.BulletHit(bulletId, ufo == null ? null : ufo.getPlayerName()));
    }

    public static interface RoundListener {
        public void roundFinished(Map<Ufo, Double> var1);
    }
}

