/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import lonelycoders.ufohippa.game.ai.AIController;
import lonelycoders.ufohippa.game.util.ColorRGB;
import lonelycoders.ufohippa.server.ControllerId;
import lonelycoders.ufohippa.server.ServerCommander;

public class ServerData {
    private final Map<String, PlayerInfo> players = new TreeMap<String, PlayerInfo>();
    private final Map<ControllerId, String[]> clientPlayers = new HashMap<ControllerId, String[]>();
    private final ServerCommander commander;
    private static final ControllerId AI = new ControllerId(){};

    public ServerData(ServerCommander commander) {
        this.commander = commander;
        this.clientPlayers.put(AI, new String[0]);
    }

    public void setPlayerSettings(ControllerId controllerId, String[] playerNames, ColorRGB[] playerColors) {
        this.setPlayerSettings(controllerId, playerNames, playerColors, null);
    }

    public void setAIPlayersSettings(String[] playerNames, ColorRGB[] playerColors, AIController[] controllers) {
        this.setPlayerSettings(AI, playerNames, playerColors, controllers);
    }

    private void setPlayerSettings(ControllerId controllerId, String[] playerNames, ColorRGB[] playerColors, AIController[] controllers) {
        if (this.clientPlayers.containsKey(controllerId)) {
            for (String playerName : this.clientPlayers.get(controllerId)) {
                this.players.remove(playerName);
            }
            this.clientPlayers.remove(controllerId);
        }
        this.clientPlayers.put(controllerId, playerNames);
        for (int i = 0; i < playerNames.length; ++i) {
            AIController controller = controllers != null ? controllers[i] : null;
            this.players.put(playerNames[i], new PlayerInfo(controllerId, playerNames[i], playerColors[i], controller));
        }
        this.commander.playerSettingsChanged(this.players.values().toArray(new PlayerInfo[this.players.size()]));
    }

    public String[] getClientPlayers(ControllerId controllerId) {
        String[] players = this.clientPlayers.get(controllerId);
        if (players == null) {
            players = new String[]{};
        }
        return players;
    }

    public boolean isRegisteredClient(ControllerId controllerId) {
        return this.clientPlayers.containsKey(controllerId);
    }

    public void removeClient(ControllerId controllerId) {
        String[] playerNames = this.clientPlayers.get(controllerId);
        this.clientPlayers.remove(controllerId);
        for (String playerName : playerNames) {
            this.players.remove(playerName);
        }
        this.commander.playerSettingsChanged(this.players.values().toArray(new PlayerInfo[this.players.size()]));
    }

    public String[] getAIPlayers() {
        return this.getClientPlayers(AI);
    }

    public boolean ensureValidPlayerSettings(ControllerId clientId, String[] playerNames, ColorRGB[] playerColors) {
        boolean changed = false;
        HashSet<String> reservedNames = new HashSet<String>();
        HashSet<ColorRGB> reservedColors = new HashSet<ColorRGB>();
        for (Map.Entry<ControllerId, String[]> entry : this.clientPlayers.entrySet()) {
            if (entry.getKey() == clientId) continue;
            String[] clientPlayerNames = entry.getValue();
            reservedNames.addAll(Arrays.asList(clientPlayerNames));
            for (String playerName : clientPlayerNames) {
                PlayerInfo playerInfo = this.players.get(playerName);
                reservedColors.add(playerInfo.getColor());
            }
        }
        for (int i = 0; i < playerNames.length; ++i) {
            String playerName;
            String testName = playerName = playerNames[i];
            int duplicateIteration = 1;
            while (reservedNames.contains(testName)) {
                testName = playerName + " " + ++duplicateIteration;
                changed = true;
            }
            playerNames[i] = testName;
            reservedNames.add(testName);
        }
        ColorRGB[] defaultColors = new ColorRGB[]{ColorRGB.BLUE, ColorRGB.CYAN, ColorRGB.GREEN, ColorRGB.ORANGE, ColorRGB.PINK, ColorRGB.RED};
        ArrayList<ColorRGB> moreColors = new ArrayList<ColorRGB>();
        for (int i = 0; i < defaultColors.length; ++i) {
            for (int j = 0; j < defaultColors.length; ++j) {
                ColorRGB newColor;
                if (i == j || (newColor = defaultColors[i].blend(defaultColors[j], 0.5f)).getRed() == newColor.getGreen() && newColor.getRed() == newColor.getBlue()) continue;
                moreColors.add(newColor);
            }
        }
        ArrayList<ColorRGB> allColors = new ArrayList<ColorRGB>(Arrays.asList(defaultColors));
        Collections.shuffle(allColors);
        Collections.shuffle(moreColors);
        allColors.addAll(moreColors);
        for (int i = 0; i < playerColors.length; ++i) {
            ColorRGB testColor = playerColors[i];
            for (ColorRGB possibleColor : allColors) {
                boolean tooNear = false;
                for (ColorRGB reservedColor : reservedColors) {
                    if (!(reservedColor.distanceTo(testColor) < 0.3f)) continue;
                    tooNear = true;
                    break;
                }
                if (!tooNear) break;
                changed = true;
                testColor = possibleColor;
            }
            playerColors[i] = testColor;
            reservedColors.add(testColor);
        }
        return changed;
    }

    public static class PlayerInfo {
        private ControllerId controllerId;
        private final String name;
        private final ColorRGB color;
        private final AIController aiController;

        private PlayerInfo(ControllerId controllerId, String name, ColorRGB color) {
            this(controllerId, name, color, null);
        }

        private PlayerInfo(ControllerId controllerId, String name, ColorRGB color, AIController aiController) {
            this.name = name;
            this.color = color;
            this.controllerId = controllerId;
            this.aiController = aiController;
        }

        public String getName() {
            return this.name;
        }

        public ColorRGB getColor() {
            return this.color;
        }

        public AIController getAiController() {
            return this.aiController;
        }

        public boolean isAiPlayer() {
            return this.aiController != null;
        }
    }
}

