/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.network.commands.match;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import lonelycoders.ufohippa.game.util.ColorRGB;
import lonelycoders.ufohippa.network.Command;
import lonelycoders.ufohippa.network.CommandHandler;
import lonelycoders.ufohippa.network.commands.UtilIO;

public class SendPlayersCommand
extends Command {
    private static final int ID = 302;
    private final int playerCount;
    private final String[] playerNames;
    private final ColorRGB[] playerColors;

    public SendPlayersCommand(int playerCount, String[] playerNames, ColorRGB[] playerColors) {
        this.playerCount = playerCount;
        this.playerNames = playerNames;
        this.playerColors = playerColors;
    }

    public SendPlayersCommand(DataInputStream dis) throws IOException {
        this.playerCount = dis.readInt();
        this.playerNames = new String[this.playerCount];
        this.playerColors = new ColorRGB[this.playerCount];
        for (int i = 0; i < this.playerCount; ++i) {
            this.playerNames[i] = dis.readUTF();
            this.playerColors[i] = UtilIO.readColorRGB(dis);
        }
    }

    @Override
    public int getId() {
        return 302;
    }

    @Override
    public void serialize(DataOutputStream dos) throws IOException {
        dos.writeInt(this.playerCount);
        for (int i = 0; i < this.playerCount; ++i) {
            dos.writeUTF(this.playerNames[i]);
            UtilIO.writeColorRGB(dos, this.playerColors[i]);
        }
    }

    public int getPlayerCount() {
        return this.playerCount;
    }

    public String[] getPlayerNames() {
        return this.playerNames;
    }

    public ColorRGB[] getPlayerColors() {
        return this.playerColors;
    }

    public static abstract class Handler
    extends CommandHandler<SendPlayersCommand> {
        @Override
        public int getId() {
            return 302;
        }

        @Override
        public SendPlayersCommand deserialize(DataInputStream dis) throws IOException {
            return new SendPlayersCommand(dis);
        }
    }
}

