/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.network.commands.match;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import lonelycoders.ufohippa.network.Command;
import lonelycoders.ufohippa.network.CommandHandler;

public class SendLevelsCommand
extends Command {
    private static final int ID = 304;
    private final String[] levelNames;

    public SendLevelsCommand(String[] levelNames) {
        this.levelNames = levelNames;
    }

    public SendLevelsCommand(DataInputStream dis) throws IOException {
        int levelCount = dis.readInt();
        this.levelNames = new String[levelCount];
        for (int i = 0; i < levelCount; ++i) {
            String name;
            this.levelNames[i] = name = dis.readUTF();
        }
    }

    @Override
    public int getId() {
        return 304;
    }

    @Override
    public void serialize(DataOutputStream dos) throws IOException {
        dos.writeInt(this.levelNames.length);
        for (String level : this.levelNames) {
            dos.writeUTF(level);
        }
    }

    public String[] getLevelNames() {
        return this.levelNames;
    }

    public static abstract class Handler
    extends CommandHandler<SendLevelsCommand> {
        @Override
        public int getId() {
            return 304;
        }

        @Override
        public SendLevelsCommand deserialize(DataInputStream dis) throws IOException {
            return new SendLevelsCommand(dis);
        }
    }
}

