/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.network.commands.match;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import lonelycoders.ufohippa.game.ufo.Ufo;
import lonelycoders.ufohippa.game.util.Vector2;
import lonelycoders.ufohippa.network.Command;
import lonelycoders.ufohippa.network.CommandHandler;
import lonelycoders.ufohippa.network.commands.UtilIO;
import lonelycoders.ufohippa.server.UpdateInfo;

public class RoundUpdateCommand
extends Command {
    private static final int ID = 402;
    private final List<PlayerData> playerDatas;
    private final List<BulletShootData> shootDatas;
    private final List<UfoCollision> ufoCollisions;
    private final List<BulletHit> bulletHits;
    private final List<UpdateInfo.SoundEffect> soundEffects;

    public RoundUpdateCommand(UpdateInfo updateInfo) {
        this.playerDatas = updateInfo.getPlayerDatas();
        this.shootDatas = updateInfo.getShootDatas();
        this.ufoCollisions = updateInfo.getUfoCollisions();
        this.bulletHits = updateInfo.getBulletHits();
        this.soundEffects = updateInfo.getSoundEffects();
    }

    @Override
    public int getId() {
        return 402;
    }

    @Override
    public void serialize(DataOutputStream dos) throws IOException {
        dos.writeInt(this.playerDatas.size());
        for (PlayerData playerData : this.playerDatas) {
            playerData.serialize(dos);
        }
        dos.writeInt(this.ufoCollisions.size());
        for (UfoCollision ufoCollision : this.ufoCollisions) {
            ufoCollision.serialize(dos);
        }
        dos.writeInt(this.shootDatas.size());
        for (BulletShootData shootData : this.shootDatas) {
            shootData.serialize(dos);
        }
        dos.writeInt(this.bulletHits.size());
        for (BulletHit bulletHit : this.bulletHits) {
            bulletHit.serialize(dos);
        }
        dos.writeInt(this.soundEffects.size());
        for (UpdateInfo.SoundEffect soundEffect : this.soundEffects) {
            dos.writeInt(soundEffect.ordinal());
        }
    }

    public Iterable<PlayerData> getPlayerDatas() {
        return this.playerDatas;
    }

    public Iterable<BulletShootData> getShootDatas() {
        return this.shootDatas;
    }

    public List<UfoCollision> getUfoCollisions() {
        return this.ufoCollisions;
    }

    public List<BulletHit> getBulletHits() {
        return this.bulletHits;
    }

    public List<UpdateInfo.SoundEffect> getSoundEffects() {
        return this.soundEffects;
    }

    public static class BulletHit {
        private final int bulletId;
        private final String playerName;

        public BulletHit(int bulletId, String playerName) {
            this.bulletId = bulletId;
            this.playerName = playerName;
        }

        public BulletHit(DataInputStream dis) throws IOException {
            this.bulletId = dis.readInt();
            this.playerName = UtilIO.readNullableString(dis);
        }

        public int getBulletId() {
            return this.bulletId;
        }

        public String getPlayerName() {
            return this.playerName;
        }

        public String toString() {
            return "BulletHit{bulletId=" + this.bulletId + ", playerName='" + this.playerName + '\'' + '}';
        }

        public void serialize(DataOutputStream dos) throws IOException {
            dos.writeInt(this.bulletId);
            UtilIO.writeNullableString(dos, this.playerName);
        }
    }

    public static class UfoCollision {
        private final String player1Name;
        private final String player2Name;
        private final String newTagName;
        private final float strength;

        public UfoCollision(String player1Name, String player2Name, String newTagName, float strength) {
            this.player1Name = player1Name;
            this.player2Name = player2Name;
            this.newTagName = newTagName;
            this.strength = strength;
        }

        public UfoCollision(DataInputStream dis) throws IOException {
            this.player1Name = dis.readUTF();
            this.player2Name = dis.readUTF();
            String newTagName = dis.readUTF();
            if (newTagName.length() == 0) {
                newTagName = null;
            }
            this.newTagName = newTagName;
            this.strength = dis.readFloat();
        }

        public String getPlayer1Name() {
            return this.player1Name;
        }

        public String getPlayer2Name() {
            return this.player2Name;
        }

        public String getNewTagName() {
            return this.newTagName;
        }

        public float getStrength() {
            return this.strength;
        }

        public String toString() {
            return "UfoCollision{player1Name='" + this.player1Name + '\'' + ", player2Name='" + this.player2Name + '\'' + ", newTagName='" + this.newTagName + '\'' + '}';
        }

        public void serialize(DataOutputStream dos) throws IOException {
            dos.writeUTF(this.player1Name);
            dos.writeUTF(this.player2Name);
            dos.writeUTF(this.newTagName != null ? this.newTagName : "");
            dos.writeFloat(this.strength);
        }
    }

    public static class BulletShootData {
        private final int bulletId;
        private final String playerName;
        private final float bounceProbability;
        private final Vector2 position;
        private final Vector2 velocity;

        public BulletShootData(int bulletId, String playerName, float bounceProbability, Vector2 position, Vector2 velocity) {
            this.bulletId = bulletId;
            this.playerName = playerName;
            this.bounceProbability = bounceProbability;
            this.position = position;
            this.velocity = velocity;
        }

        public BulletShootData(DataInputStream dis) throws IOException {
            this.bulletId = dis.readInt();
            this.bounceProbability = dis.readFloat();
            this.playerName = dis.readUTF();
            this.position = UtilIO.readVector2(dis);
            this.velocity = UtilIO.readVector2(dis);
        }

        public String getPlayerName() {
            return this.playerName;
        }

        public float getBounceProbability() {
            return this.bounceProbability;
        }

        public int getBulletId() {
            return this.bulletId;
        }

        public Vector2 getPosition() {
            return this.position;
        }

        public Vector2 getVelocity() {
            return this.velocity;
        }

        public String toString() {
            return "BulletShootData{bulletId=" + this.bulletId + ", playerName='" + this.playerName + '\'' + ", bounceProbability=" + this.bounceProbability + ", position=" + this.position + ", velocity=" + this.velocity + '}';
        }

        public void serialize(DataOutputStream dos) throws IOException {
            dos.writeInt(this.bulletId);
            dos.writeFloat(this.bounceProbability);
            dos.writeUTF(this.playerName);
            UtilIO.writeVector2(dos, this.position);
            UtilIO.writeVector2(dos, this.velocity);
        }
    }

    public static class PlayerData {
        private static final int CONTROL_COUNT = Ufo.Control.values().length;
        private final String name;
        private final Vector2 position;
        private final Vector2 velocity;
        private final boolean[] controls;

        public PlayerData(String name, Vector2 position, Vector2 velocity, boolean[] controls) {
            this.name = name;
            this.position = position;
            this.velocity = velocity;
            this.controls = controls;
        }

        public PlayerData(DataInputStream dis) throws IOException {
            this.name = dis.readUTF();
            this.position = UtilIO.readVector2(dis);
            this.velocity = UtilIO.readVector2(dis);
            this.controls = new boolean[CONTROL_COUNT];
            for (int i = 0; i < CONTROL_COUNT; ++i) {
                this.controls[i] = dis.readBoolean();
            }
        }

        public void serialize(DataOutputStream dos) throws IOException {
            dos.writeUTF(this.name);
            UtilIO.writeVector2(dos, this.position);
            UtilIO.writeVector2(dos, this.velocity);
            assert (this.controls.length == CONTROL_COUNT);
            for (boolean control : this.controls) {
                dos.writeBoolean(control);
            }
        }

        public String getName() {
            return this.name;
        }

        public Vector2 getPosition() {
            return this.position;
        }

        public Vector2 getVelocity() {
            return this.velocity;
        }

        public boolean[] getControls() {
            return this.controls;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("{");
            for (int i = 0; i < this.controls.length; ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(this.controls[i]);
            }
            sb.append('}');
            return "PlayerData{name='" + this.name + '\'' + ", position=" + this.position + ", velocity=" + this.velocity + ", controls=" + sb.toString() + '}';
        }
    }

    public static abstract class Handler
    extends CommandHandler<RoundUpdateCommand> {
        @Override
        public int getId() {
            return 402;
        }

        @Override
        public RoundUpdateCommand deserialize(DataInputStream dis) throws IOException {
            UpdateInfo updateInfo = new UpdateInfo();
            int playerCount = dis.readInt();
            for (int i = 0; i < playerCount; ++i) {
                updateInfo.addPlayerData(new PlayerData(dis));
            }
            int ufoCollisionCount = dis.readInt();
            for (int i = 0; i < ufoCollisionCount; ++i) {
                updateInfo.ufosCollided(new UfoCollision(dis));
            }
            int shootCount = dis.readInt();
            for (int i = 0; i < shootCount; ++i) {
                updateInfo.bulletShot(new BulletShootData(dis));
            }
            int bulletHitCount = dis.readInt();
            for (int i = 0; i < bulletHitCount; ++i) {
                updateInfo.bulletHit(new BulletHit(dis));
            }
            int soundEffectCount = dis.readInt();
            for (int i = 0; i < soundEffectCount; ++i) {
                updateInfo.addSoundEffect(UpdateInfo.SoundEffect.values()[dis.readInt()]);
            }
            return new RoundUpdateCommand(updateInfo);
        }
    }
}

