/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.network.commands.lobby;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import lonelycoders.ufohippa.network.Command;
import lonelycoders.ufohippa.network.CommandHandler;

public class AllLevelSettingsCommand
extends Command {
    private static final int ID = 202;
    private final int levelCount;
    private final String[] levelNames;

    public AllLevelSettingsCommand(int levelCount, String[] levelNames) {
        this.levelCount = levelCount;
        this.levelNames = levelNames;
    }

    public AllLevelSettingsCommand(DataInputStream dis) throws IOException {
        this.levelCount = dis.readInt();
        this.levelNames = new String[this.levelCount];
        for (int i = 0; i < this.levelCount; ++i) {
            this.levelNames[i] = dis.readUTF();
        }
    }

    @Override
    public int getId() {
        return 202;
    }

    @Override
    public void serialize(DataOutputStream dos) throws IOException {
        dos.writeInt(this.levelCount);
        for (int i = 0; i < this.levelCount; ++i) {
            dos.writeUTF(this.levelNames[i]);
        }
    }

    public int getLevelCount() {
        return this.levelCount;
    }

    public String[] getLevelNames() {
        return this.levelNames;
    }

    public static abstract class Handler
    extends CommandHandler<AllLevelSettingsCommand> {
        @Override
        public int getId() {
            return 202;
        }

        @Override
        public AllLevelSettingsCommand deserialize(DataInputStream dis) throws IOException {
            return new AllLevelSettingsCommand(dis);
        }
    }
}

