/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.network;

import java.io.DataInputStream;
import lonelycoders.ufohippa.network.Command;
import lonelycoders.ufohippa.network.CommandSender;
import lonelycoders.ufohippa.network.NetworkProtocolException;

public abstract class State {
    protected final String name;
    private CommandSender commandSender;
    private boolean active;

    protected State(String name) {
        this.name = name;
    }

    public void connected(CommandSender commandSender) throws NetworkProtocolException {
        this.commandSender = commandSender;
    }

    public void sendCommand(Command command) {
        try {
            this.commandSender.sendCommand(command);
        }
        catch (NetworkProtocolException e) {
            this.commandSender.exceptionCaught(e);
        }
    }

    public abstract State readCommand(DataInputStream var1) throws NetworkProtocolException;

    public void setActive(boolean active) {
        this.active = active;
    }

    public String toString() {
        return this.name;
    }

    public boolean isActiveState() {
        return this.active;
    }
}

