/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.network;

import java.io.DataOutputStream;
import java.io.IOException;
import lonelycoders.ufohippa.general.CommandQueue;
import lonelycoders.ufohippa.general.Logger;
import lonelycoders.ufohippa.network.Command;
import lonelycoders.ufohippa.network.NetworkProtocolException;

public abstract class CommandSender {
    private final CommandQueue commandQueue;

    public CommandSender(String name) {
        this.commandQueue = new CommandQueue(name);
        this.commandQueue.start();
    }

    public void sendCommand(final Command command) throws NetworkProtocolException {
        Logger.detail("Sending " + command + " to " + this.getTarget());
        this.commandQueue.addTask(new Runnable(){

            @Override
            public void run() {
                try {
                    Logger.detail("Sending command");
                    DataOutputStream dos = CommandSender.this.getDataOutputStream();
                    int commandId = command.getId();
                    try {
                        dos.writeInt(commandId);
                        command.serialize(dos);
                        dos.flush();
                    }
                    catch (IOException e) {
                        throw new NetworkProtocolException(e);
                    }
                }
                catch (NetworkProtocolException e) {
                    CommandSender.this.exceptionCaught(e);
                }
            }
        });
    }

    public void stop() {
        this.commandQueue.stop();
    }

    public abstract String getTarget();

    protected abstract DataOutputStream getDataOutputStream();

    public abstract void exceptionCaught(NetworkProtocolException var1);

    public void waitForReady() {
        this.commandQueue.waitForDone();
    }
}

