/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.general.logger;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import lonelycoders.ufohippa.general.Logger;
import lonelycoders.ufohippa.general.logger.LoggerHandler;

public class FileLoggerHandler
implements LoggerHandler {
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("H:mm:ss.SSS");
    private PrintWriter pw;

    public FileLoggerHandler(File file) {
        try {
            this.pw = new PrintWriter(file);
        }
        catch (FileNotFoundException e) {
            System.err.println("Failed to create file logger");
            e.printStackTrace();
        }
    }

    @Override
    public void handle(Logger.Level level, String threadName, Date date, String message) {
        if (this.pw != null) {
            this.pw.println(dateFormat.format(date) + " " + level.name() + " [" + threadName + "]: " + message);
            this.pw.flush();
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.pw != null) {
            this.pw.close();
        }
    }
}

