/*
 * Decompiled with CFR 0.152.
 */
package lonelycoders.ufohippa.general;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import lonelycoders.ufohippa.general.Logger;
import lonelycoders.ufohippa.general.StoppableThread;

public class CommandQueue {
    private final BlockingQueue<Runnable> commandQueue = new LinkedBlockingDeque<Runnable>();
    private final StoppableThread thread;

    public CommandQueue(String name) {
        this.thread = new StoppableThread(name, new Runnable(){

            @Override
            public void run() {
                CommandQueue.this.processCommand();
            }
        });
    }

    public void addTask(Runnable task) {
        try {
            if (!this.thread.isAlive()) {
                return;
            }
            this.commandQueue.put(task);
        }
        catch (InterruptedException e) {
            Logger.exception(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCommand() {
        try {
            Runnable runnable = this.commandQueue.take();
            runnable.run();
            CommandQueue commandQueue = this;
            synchronized (commandQueue) {
                this.notify();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void start() {
        this.thread.start();
    }

    public void stop() {
        this.thread.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForDone() {
        CommandQueue commandQueue = this;
        synchronized (commandQueue) {
            while (!this.commandQueue.isEmpty()) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Logger.exception(e);
                }
            }
        }
    }
}

